<?php	// ۞//	 text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
													$thumber_version = '0.8.2';

/*
		"Thumber"

		 corz.org simple, dynamic, xhtml-compliant GD thumbnail generator

		This program will scan a directory for images, and create a page of 
		thumbnails which the user can click to see the image proper.

		Features..

			Dynamic thumbnail generation AND deletion:

				If you add an image to the directory, a new thumbnail will be 
				created. If you remove an image from the directory, its 
				thumbnail will be deleted. Simple.

			Automatically sized pop-ups!:

				Image dimensions are recorded (at thumbnail generation time) and 
				stored in an ini file inside the thumbnail directory. The 
				dimension information is then used to size the JavaScript 
				pop-ups. Pretty neat.

			Fully Configurable thumbnails:

				You can have either high or low quality, jpeg or png. You can 
				also specify the size and location of stored thumbnails.

			Automatic Thumbnail Update:

				If you update an image in any way, Thumber will create a new 
				thumbnail for that image (modification time is also stored).

			Stand-Alone or Embedded Operation:

				Thumber can be easily embedded inside your web pages, or else
				function in a stand-alone state. Or both, all-at-once.


		Installation..

			Edit the preferences (below).

			Drop this script somewhere on your webserver, /inc/ or /includes/ is 
			recommended. Alternatively, you can drop thumber.php directly into a 
			directory of images. The former is more flexible, as a single 
			Thumber installation can service your entire site. You can also do 
			both.

			Thumber stores the thumbnails (and 'thumbs.ini') inside a directory 
			called "thumbs" inside the images directory. (you can use whatever 
			name you like, set that below) which needs to exist (Thumber will 
			try to create it if it doesn't, but unless you run some form of 
			suexec system, it's highly likely this would fail; in which case, 
			make the directory manually.), and be "world-writable" so that 
			Thumber is free to create, update, and delete the files inside it.

			Use your FTP client to set permissions to ALL (777) or in a *nix 
			shell do "chmod 777 /path/to/thumbs" (no quotes). If your server 
			runs suexec, you shouldn't need to do anything. Just drop in 
			thumber.php.


		Usage..

		  There are two different methods of calling Thumber, depending on how 
		  you want to use it..

		  1.

			Firstly, you can call it via an HTTP request, specifying the image 
			directory (full path from your document (domain) root) in the 
			request, with a regular page link..

				<a href="/inc/thumber.php?dir=/stuff/imges/'">THUMBS!</a>
			
			or include(), like this..

				$host = $_SERVER['HTTP_HOST'];
				include('http://'.$host.'/inc/thumber.php?dir=/stuff/imges/');

			fileread() should just work, too. Here we are using basic $_GET 
			variables to set Thumber's path. NOTE: Many server setups won't 
			allow URL includes. If you can't use regular links for some reason, 
			or want to embed Thumber inside some other page, see method 2, 
			below.

			When called this way, Thumber uses the absolute path (from site 
			root) you specify, and creates a proper XHTML page to contain all 
			the thumbs.

			That is all you have to do. And you can have links all over your 
			site, with Thumber links to directorys of images all over your site. 
			So long as each has a "thumbs" directory inside it, which Thumber 
			can write to, everything should work as expected.


		  2.

			You can also embed Thumber in your pages using regular php 
			include(), e.g..

				include($_SERVER['DOCUMENT_ROOT'].'/inc/thumber.php');

			Where Thumber will generate thumbnails for the named directory 
			*relative* to the calling script (by default). And by default the 
			setting is blank, so Thumber looks in the same dir as the calling
			script. For instance, if you called Thumber from inside a page at..

				/stuff/more/index.php

			Thumber would generate images for..

				/stuff/more/

			and create thumbnails (and the thumbs.ini file) here..

				/stuff/more/thumbs/

			In other words, if the page, and its images are in the same directory,
			and you have a writable dir ready for the thumbs, you do one single
			include, and everything just works. There is more, though..

			You can set another directory before you include Thumber..
			
				$thumber_dir = 'MyImages';
				include($_SERVER['DOCUMENT_ROOT'].'/inc/thumber.php');

			And now Thumber will be looking for images in..

				/stuff/more/MyImages/

			Also, you can specify some HTML to go inside Thumber's <h1> header 
			(before its own 'click any thumbnail..' message, but still nicely 
			inside its column, so everything looks neat). Let's do both now..

				$thumber_dir = 'MyImages';
				$thumber_header = 'My Amazing Images..<br />
				<small>The BEST Images in the WORLD!!</small><br />';
				include($_SERVER['DOCUMENT_ROOT'].'/inc/thumber.php');


		If you wanted to embed Thumber, but use a directory of images outside
		the current path, you can also specify a site path, that is, just like
		the HTTP GET method, you specify a site root path by beginning it with a 
		forward slash..

				$thumber_dir = '/Some/Path/To/Other/Images';
				include($_SERVER['DOCUMENT_ROOT'].'/inc/thumber.php');


		Finally, you can also set $thumbs_path before calling, which is the path 
		to a directory, relative to the main image directory. If you set it to 
		an empty value, thumbs are created in the same directory as the main 
		images. By default, it is set to 'thumbs'.


		The two methods (HTTP and include()) are not mutually exclusive, so you 
		can set a "default" directory name inside Thumber, and then, if you need 
		to, call it later via the HTTP or include() method, specifying a 
		different directory name, which will override the default. You can 
		easily set directories on a global or per-page basis, create ad-hoc
		links with static and on-the-fly galleries, or everything all-at-once,
		with just one copy of thumber.

		Have fun!

		;o) Cor

		(c) corz.org 2005 ->
*/





/*

	prefs..

			 */



/*
	Image Directory Name..						   [default: $thumber_dir = '';]

	Where images are kept. Normally this will be overridden by incoming $_GET 
	variables, or set in the calling script, but you may wish to use a keep a 
	standard image directory name. However you use Thumber, this will act as the 
	default fall-back image directory name.

	To use a location from your site root, add a slash at the start, e.g..

		$thumber_dir = '/imaging/Wallpaper/';

	The Sample Images demo uses a location relative to thumber.php, like so..
*/
if (!isset($thumber_dir)) { $thumber_dir = 'Sample Images/'; }
//if (!isset($thumber_dir)) { $thumber_dir = ''; }
/*
	By default, Thumber looks in the current directory (''), so you can drop 
	thumber.php, as-is, into a directory of images (perhaps renamed to 
	index.php), and get thumbs right off the bat.

	NOTE: The distro now has a Sample Images folder.

	If embedding Thumber, you would set this (if required) before include()-ing 
	this script, as in the Usage examples, above.
*/



/*
	Thumbnails Directory Name..				 [default: $thumbs_path = 'thumbs';]

	Thumber writes stuff in here, so this directory needs to be world-writable 
	(or user-writeable, if under cgi/suexec).

	If you leave this blank, thumbs will be created in the same directory as
	the main images. Obviously you also need to have the main image directory
	writable by the server process.

*/
if (!isset($thumbs_path)) { $thumbs_path = 'thumbs'; }
/* 
	Again, you can set this before you call Thumber
	(it's starting to look like a class might be a good idea!)

	Trailing slash is optional */



/*
	INI File Name..						   [default: $data_file = 'thumbs.ini';]

	The name of thumbs ini file (stored inside thumbs directory)
*/
$data_file = 'thumbs.ini';



/*
	CSS Location..				  [default: $css_file = 'css/thumber.css';]

	Where is the style sheet? (normally from site root) e.g..

		$css_file = '/inc/css/thumber.css';

	But relative works fine, too..

*/
$css_file = 'css/thumber.css';



/*
	Thumbnail Size										 [default: $size = 200;]
*/
$size = 200;



/*
	High Quality Scaling..						  [default: $hq_scaling = true;]

	Images are resampled, not rescaled. This is better.

	Here, we can increase quality further by using "true color" scaling..

	Set to 'true' for high quality, 'false' for lower quality (8-bit) scaling. 
	
	NOTE: you need a GD v2.something to use this.
*/
$hq_scaling = true;



/*
	JPEG Thumbnail Quality..						   [default: $q_ratio = 75;]

	This is only for saved jpeg thumbnails, png is always lossless.
	JPEG compression ratio: 0 - 100. 
	50 is okay, 75 is nice, over 90 is madness.
*/
$q_ratio = 75;



/*
	Thumbnail Type..							 [default: $thumb_type = 'jpg';]

	Thumbnail type, either 'png' or 'jpg'. I have no plans to support the gif 
	format. if $hq_scaling (above) is set to false, use 'png', or you will eat 
	space for nothing.
*/
$thumb_type = 'jpg';

/*
	Quality and Size notes..

	For the highest quality truecolor thumbs, with alpha layer and transparency,
	use:

		$hq_scaling = true;
		$thumb_type = 'png';

	Save disk space by using lower quality (8-bit) settings:

		$hq_scaling = false;
		$thumb_type = 'png';

	.. which will produce the smallest images of all, but the quality is poor.

	Most people will probably want to do something like this:

		$hq_scaling = true;
		$q_ratio = 75;
		$thumb_type = 'jpg';

	Which will produce a nice quality truecolor result with a small sized file; 
	ideal for most purposes. 
*/



/*
	Use GD											  [default: $use_gd = true;]

	Normally, this is true, of course. Thumber is nothing without GD!

	However, you may wish to make the thumbs at home and run Thumber on a server 
	that has no GD. Make this false for the online version, and Bob's yer Uncle! 
*/
$use_gd = true;



/*
	Pop-Up Screen Location					[default: $pop_x = 250;$pop_y = 18;]

	Where on the user's screen will the pop-up, pop up?
*/
$pop_x = 250;
$pop_y = 18;



/*
	Legacy thumbs.nfo					  [default: $legacy_nfo = 'thumbs.nfo';]

	Update legacy database..

	If you've already got some Thumber databases lying around that you'd like to 
	use, you can insert the name of the file here, and Thumber will update them 
	to the new ini format, automatically..
*/
$legacy_nfo = 'thumbs.nfo';




/* 
	Force Thumbs Rebuild..							[default: $rebuild = false;]

	Even if a thumbnail exists, rebuild it!		*yikes*
*/
$rebuild = false;
//
// better yet, see the following pref..



/*

	Force Rebuild (Password)

	You can force Thumber to rebuild its thumbnails from your web browser, by 
	adding "?rebuild=MyPassword" (no quotes), replacing "MyPassword" with 
	whatever you set here.

	This can be handy when you change some of the thumbnail preferences (above)
	or upgrade GD, or just in jam. Anyways, it's there if required.

	To disable this functionality altogether, simply leave the password blank.

*/
$admin_pass = '';

// Okay, not exactly pajamas authentication, but hey, it's just thumbs!
// However, there is the potential for a DDOS, hence the password.



/*

	end prefs

				*/



// init..
$domain = $_SERVER['HTTP_HOST'];
$using_get = false;
$embedded = true;
if (realpath($_SERVER['SCRIPT_FILENAME']) == realpath(__FILE__)) { $embedded = false; }

// for building large sets of thumbs. rarely needed these days..
ini_set ('max_execution_time', 300);

Header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
Header('Expires: Tue, 01 Apr 1970 00:00:00 GMT'); // My Birthday! ;o)
Header('Pragma: no-cache');


// GET Variables..
//

// which directory of images?
// catch confusing legacy item, first..
if (isset($_GET['folder'])) { $thumber_dir = $_GET['folder']; $using_get = true; }
if (isset($_GET['dir'])) { $thumber_dir = $_GET['dir']; $using_get = true; }

// force-rebuild via GET variables..
if (!empty($_GET['rebuild']) and $_GET['rebuild'] == $admin_pass) {
	$rebuild = true; 
}


// Path fix-ups..
//

if ($thumb_type != 'jpg' and $thumb_type != 'png' ) { $thumb_type = 'jpg'; }
if (($thumb_type == 'jpg') and ($hq_scaling == false)) { $thumb_type = 'png'; }

// normalize path-ends..
if ($thumber_dir and substr($thumber_dir, - 1) != '/') $thumber_dir .= '/';
if ($thumbs_path and substr($thumbs_path, - 1) != '/') $thumbs_path .= '/';

// where in the *&@$*! (server) are we ? ..		
//
if ($using_get) {
	$path = $_SERVER['DOCUMENT_ROOT'];				// for finding the images
	$http_img_path = $thumber_dir;					// for creating URIs
} else {
	if (substr($thumber_dir, 0, 1) == '/') {		// a site-path (relative to site-root)
		$path = $_SERVER['DOCUMENT_ROOT'];
		$http_img_path = $thumber_dir;
	} else {
		// ascertain physical path..
		$path =  substr($_SERVER['SCRIPT_FILENAME'], 0, (strrpos($_SERVER['SCRIPT_FILENAME'], '/') + 1));
		// exctract URI path from real path..
		$http_img_path = '/'.substr($path, strlen($_SERVER['DOCUMENT_ROOT']) + 1, strlen($path)).$thumber_dir;
	}
}

// more readable..
$full_path = $path.$thumber_dir;
$db_path = $full_path.$thumbs_path.$data_file;



// well, we can try! (should work fine on cgi/suexec systems)..
if (!file_exists($thumbs_path)) {
	@mkdir($thumbs_path);
}

// update old nfo files to new ini format..
if ($legacy_nfo and !file_exists($db_path) and file_exists($full_path.$thumbs_path.$legacy_nfo)) {
	update_legacy_database($legacy_nfo);
}



// let's go!
//
$img_list = scan_img_dir($full_path);


// read the ini data..
$ini_data = read_thumbs_ini($db_path);


// create our sizes array, for later use..
$sizes_array = false;
if (is_array($ini_data)) { 
	$sizes_array = $ini_data['image-data']; 
}


// remove stale database entries, and their thumbnails..
if (is_array($sizes_array)) {
	foreach ($sizes_array as $key => $value) {
		// if $key (filename in database) is not currently in the images directory..
		if (!array_key_exists($key, $img_list)) {
			// establish the path of the thumb..
			$base_name = substr(basename($full_path.$key), 0, -4); // it's always 3 characters (jpg|png)
			$old_thumb = $full_path.$thumbs_path.$base_name.'_thm.'.$thumb_type;
			// and delete it..
			if (file_exists($old_thumb)) {  
				@unlink($old_thumb);							//2do.. check for error and post/log something.
				// as well as the database entry itself..
				write_thumbs_ini_value($db_path, 'image-data', $key);
			}
			// lastly, remove the actual key from $sizes_array
			unset($sizes_array[$key]);
		}
	}
}


/*

	Time to make the page..

							*/



if (!$embedded) {
	do_header(); 
}


echo '
<script type="text/javascript">
//<![CDATA[
<!--
function OpenImageWindow(theURL, width, height, left, top) {
	{
	CorzWin=window.open(theURL , "CorzWin" ,"width="+ width +",height="+ height +",left="+ left +", top="+ top +", toolbar=no,directories=0,menubar=no,status=no,resizable=1,location=0,scrollbars=0,copyhistory=1")
	}
	CorzWin.resizeTo(width + 60, height + 81);
	CorzWin.focus();
}
//-->
//]]>
</script>';


echo '
	<div class="thumbox">
		<h1 class="thumbertitle">';
if (isset($thumber_header)) {
	echo $thumber_header,'<br />';
} else {
	echo basename($thumber_dir),': ';
}
echo '
			<span id="tsubtitle">Click any thumbnail for the full-sized image..</span>
		</h1>';



// let's spit it out that array..
//
if (@count($img_list) > 0) {
	sort($img_list);
	$thumber_dirsize = count($img_list);
	for ($a = 0 ; $a < $thumber_dirsize ; $a++) {
		if ($a == $thumber_dirsize) {
			break;
		} else {
			$image_name = $img_list[$a]['name'];
			$img_data = @explode('|', $sizes_array[$image_name]);
			$orig_time = 0;
			if (isset($img_data[2])) { $orig_time = $img_data[2]; }

			// determine the full path to the image..
			$image = $full_path.$image_name;
			$image_time = filemtime($image);

			// basename, without extension..
			$base_name = substr(basename($image), 0, -(strlen(substr(strrchr($image, "."), 1)) + 1));
			$thumbnail = $full_path.$thumbs_path.$base_name.'_thm.'.$thumb_type;

			// no thumbnail? let's create one..
			if (!file_exists($thumbnail) or $rebuild or (abs($image_time - $orig_time) > 1)) {
				make_thumb($image, $size, $size, $hq_scaling, $thumbs_path, $thumb_type);
				if ($use_gd) { // add this image to the datavase..
					write_thumbs_ini_value($db_path, 'image-data', $image_name, $orig_width.'|'.$orig_height.'|'.$image_time); 
				}
			} else {
				// use stored values..
				$orig_width = $img_data[0]; 
				$orig_height = $img_data[1];
			}

			// for mouseover titles..
			$pretty_name = str_replace('_', ' ', $image_name);
			$pretty_name = substr($pretty_name, 0, strrpos($pretty_name, '.'));

			// selective entity encoding..
			$doc_img_path = str_replace(' ', '%20', $http_img_path.$image_name);
			$doc_img_path = str_replace('[', '%5B', $doc_img_path);
			$doc_img_path = str_replace(']', '%5D', $doc_img_path);
			$doc_img_path = str_replace('!', '%21', $doc_img_path);

			$srcdir = str_replace(' ', '%20', $thumber_dir);

			// display thumbnail with JavaScript pop-up code..
			// (gotta repeat the img tag to validate as XHML 1.0 Strict)
			echo '
		<script type="text/javascript">
		//<![CDATA[
		<!--
			document.write("<a title=\"',$pretty_name,'\" href=\"javascript:OpenImageWindow(\'',$doc_img_path
				,'\',',$orig_width,',',$orig_height,',',$pop_x,',',$pop_y,')\" title=\"corz image viewer: ',$base_name,'\"><img class=\"thumb\" src=\"',htmlentities($srcdir.$thumbs_path.$base_name.'_thm.'.$thumb_type),'\" alt=\"',$pretty_name,'\" \/><\/a>");
		//-->
		//]]>
		</script>
		<noscript>
			<div style="float:left">
				<a href="',htmlentities($doc_img_path),'" title="',$pretty_name,'">
				<img class="thumb" src="',htmlentities($srcdir.$thumbs_path.$base_name.'_thm.'.$thumb_type),'" alt="',$pretty_name,'" />
				</a>

			</div>
		</noscript>';
		}
	}
	echo '
		<div class="clear">&nbsp;</div>
		<div class="subthumber">
			Thumbs by <a href="http://corz.org/engine?section=php/imaging&amp;source=menu" 
			title="corz.org.. where the tech is" onclick="window.open(this.href); return false;">Thumber</a>..
			A dynamic GD thumbnail image gallery generator.. from corz.org<br />
			<noscript>
				<span class="bottom-sub"><b>note:</b> if your pop-up doesn\'t automatically resize to fit the image, check your web 
				browser\'s javascript security settings, possibly you have that disabled.</span>
			</noscript>
		</div>';
}

echo '
	</div>';
	
if (!$embedded) {
	echo '
</div>
</body>
</html>
';
}




/*

	 fin

			*/




/*
scan a directory for its images, returns an array of image filenames	
									*/
function scan_img_dir($thumber_dir) {
	$img_list = array();
	if ($the_dir = @opendir($thumber_dir)) {
		while (false != ($file = readdir($the_dir))) {
			// check which files to allow, no invisibles (which may share same extensions - mac)
			if ((eregi("(\\.png|\\.jpeg|\\.jpg)$", $file)) and (ord($file) != 46) and !strstr($file, '_thm')) {
				$img_list[basename($file)]['name'] = basename($file);
			}
		}
	} else { 
		echo'
	<div class="nodir-err-msg">Thumber couldn\'t find the specified directory!</div>'; }
	return $img_list;
}




/*
function make thumb()

feed it..	full valid path to an image
			required thumbnail width
			required thumbnail height
			quality setting (0 = low, 1 = high) (or true/false, whatever)
			thumbnail path (relative to directory containing source image)
			thumbnail type, either 'jpg', or 'png'.
																			*/
function make_thumb($image, $width, $height, $hq_scaling, $thumbs_path, $ttype) {
global $orig_height, $orig_width, $q_ratio, $use_gd;

	$thumb_width = $width;
	$thumb_height = $height;

	// get paths..
	$ext = substr(strrchr($image, "."), 1);
	$base_name = substr(basename($image), 0, -(strlen($ext) + 1));

	$thumb_name = substr($image, 0, strrpos($image, '/') + 1).$thumbs_path.$base_name.'_thm.'.$ttype;

	if ($use_gd) {
		// what type of image are we working with?..
		if ( $ext == 'jpeg' or $ext == 'jpg' or $ext == 'JPEG' or $ext == 'JPG') {
			$type = 'jpg';
			$src = imagecreatefromjpeg($image) or die("error opening image. sorree");

		} else if ($ext == 'png' or $ext == 'PNG') {
			$type = 'png';
			$src = imagecreatefrompng($image) or die("error opening image. sorree");
			imagesavealpha ($src, true);
		}

		$orig_width = imagesx($src);
		$orig_height = imagesy($src);
		$thumb_width = $width;
		$thumb_height = $height;

		// retain aspect ratio..
		if ($orig_width > $orig_height) {
			$thumb_height = $orig_height * ($height / $orig_width);
		}
		if ($orig_width < $orig_height) {
			$thumb_width = $orig_width * ($width / $orig_height);
		}

		if ($hq_scaling) {
			$thumb = imagecreatetruecolor($thumb_width, $thumb_height) or die("can't create image.sorree");
			imagecopyresampled($thumb, $src, 0, 0, 0, 0, $thumb_width, $thumb_height, $orig_width, $orig_height)
				or die("couldn't resize image. sorree.");
		} else {
			// looks like shit, but creates smaller images..
			$thumb = imagecreate($thumb_width, $thumb_height) or die("can't create image.sorree");
			imagesavealpha ($thumb, true);
			imagecopyresampled($thumb, $src, 0, 0, 0, 0, $thumb_width, $thumb_height, $orig_width, $orig_height)
				or die("couldn't resize image. sorree.");
			imagesavealpha ($thumb, true);
		}

		if ($ttype == 'png' or (($ttype == 'jpg') and !$hq_scaling)) {
			@imagepng($thumb, $thumb_name, $q_ratio) or die("couldn't save thumb. sorree");
		} else {
			@imagejpeg($thumb, $thumb_name, $q_ratio) or die("couldn't save thumb. sorree");
		}

		imagedestroy($src) or die("couldn't destroy the image from memory! oh oh!");
		imagedestroy($thumb) or die("couldn't destroy the image from memory! oh oh!");
	}
}



// Adapted from something in the php manual comments, sorta..
function read_thumbs_ini($data_file) {

	$ini_array = false;
	$sec = false;
	$config_array = @file($data_file);

	for ($i = 0;$i<@count($config_array);$i++) {
		$newsec = 0;
		$data = @trim($config_array[$i]);
		if ($data) {
			if ((!$ini_array) or ($sec)) {
				if ((@substr($data, 0, 1) == '[') and (@substr($data, -1, 1)) == ']') {
					$sec = @substr($data, 1, @strlen($data)-2);
					$newsec = 1;
				}
			}
			if (!$newsec) {
				if (@substr($data, 0, 1) == ';' or @substr($data, 0, 1) == '#') {
					continue; 
				}
				$data = @explode('=', $data);
				$k = @trim($data[0]);
				unset($data[0]);
				$v = @trim(@implode('=', $data));
				if ((@substr($v, 0, 1) == '"') and (@substr($v, -1, 1) == '"')) {
					$v = @substr($v, 1, @strlen($v)-2);
				}
				if ($sec) {
					$ini_array[$sec][$k]  =  $v;
				} else {
					$ini_array[$k]  =  $v;
				}
			}
		}
	}
	if (is_array($ini_array)) {
		return $ini_array;
	} else {
		return false;
	}
}




/*
	Write an ini value.	(adapted from something in my ini-tools.php)

	usage: 

		bool write_ini_value(String {file path}, String {section name}, String {key name}, String {its value})

	If the key exists, its value will be set to the your value.
	If the key does not exist, it will be created, and then set.
	If the section does not exist, it too, is created, and then the 'key = "value"' pair added.

	NOTE: You can remove keys by setting them to an empty value by omitting the 4th (value) parameter.

	This function relies upon the following other functions:

		read_thumbs_ini()
		write_thumbs_ini_array_to_file()
																			*/
function write_thumbs_ini_value($data_file, $section, $key, $value='') {

	$done = false;
	$ini_array = read_thumbs_ini($data_file);
	if (is_array($ini_array)) {
		foreach ($ini_array as $ky => $val) {
			if ($ky == $section) {
				foreach ($val as $ky2 => $val2) {
					if ($ky2 == $key) {
						// alter the value of this key..
						if ($value) {
							$ini_array[$section][$key] = $value;
						} else {
							// delete a key..
							unset($ini_array[$section][$key]);
						}
						$done = true;
					}
				}
			}
		}
		// no changes, add a new key = value pair..
		if (!$done) {
			$ini_array[$section][$key] = $value;
		}
	} else {
		// Start a whole new section..
		$ini_array = array($section => array($key => $value));
	}
	// write out the complete ini file..
	write_thumbs_ini_array_to_file($ini_array, $data_file);
	return true;
}





// Does what it says on the tin..
// Based on something nicked from the php manual..
function write_thumbs_ini_array_to_file($ini_array, $data_file) {

	if (!is_array($ini_array)) { return false; }

	$ini_data = '';
	foreach ($ini_array as $key => $value) {
		$ini_data .= '['.$key."]\n";
		foreach ($value as $key2 => $value2) {
			if (is_array($value2)) {
				for($i=0; $i < count($value2); $i++) {
					$ini_data .= $key2."[] = \"".$value2[$i]."\"\n";
				}
			} elseif ($value2 == '') {
				$ini_data .= $key2." = \n";
			} else {
				$ini_data .= $key2." = \"".$value2."\"\n";
			}
		}
	}
	return write_new_thumb_ini($data_file, $ini_data, true);
}



function update_legacy_database($legacy_nfo) {
	$full_nfo_path = $GLOBALS['path'].$GLOBALS['dir'].$GLOBALS['thumbs_path'].$legacy_nfo;
	if (!file_exists($full_nfo_path)) { return false; }
	$tmp_data = "\n[image-data]\n";
	$tmp_data .= trim(file_get_contents($full_nfo_path));
	$tmp_data = str_replace('/', '|', $tmp_data."\n");
	$wrote_ini = write_new_thumb_ini($GLOBALS['db_path'], $tmp_data, true);
	if ($wrote_ini) {
		if ($legacy_nfo != Basename($GLOBALS['db_path']) and filesize($GLOBALS['db_path']) > 0 ) {
			unlink($full_nfo_path);
		}
	}
	return $wrote_ini;
}



/*
function write_new_thumb_ini()

	writes a string of data safely to a flat file
	simply supply full file path and data (string)
													*/
function write_new_thumb_ini($data_file, $data, $newfile=false) {
	$prep = '';
	if ($newfile) { $prep = "; Thumbs info database for 'Thumber'..\n; corz.org dynamic GD thumbnail generator.. http://corz.org/engine\n"; }
	$fp = @fopen($data_file, 'wb'); // create first, just in case
	if (is_writable($data_file)) {
		$lock = flock($fp, LOCK_EX);
		if ($lock) {
			fwrite($fp, $prep.$data);
			flock ($fp, LOCK_UN);
		} else { return false; }
		fclose($fp);
		clearstatcache();
	} else { return false; }
	return true;
}


function do_header() {
	echo '<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
<title>Viewing: ',$GLOBALS['thumber_dir'],' with Thumber.. A dynamic GD thumbnail image gallery generator.. from corz.org. v',$GLOBALS['thumber_version'],'</title>
<meta name="description" content="thumbnails,images,thumbnail images,create thumbs,create thumbnail images,thumbnail creator,generate,generator,image thumbs,thumber" />
<style type="text/css">
/*<![CDATA[*/ 
@import "/inc/css/main.css"; /* for my header, you can put your own css imports here. */
@import "',$GLOBALS['css_file'],'"; 
@import "/inc/css/footer.css"; /* again for a footer */
}
/*]]>*/
</style>
</head>
<body>
<div class="container">';
}

/*


Itstory..

	0.8.*

	+	You can now use site paths (from site root) in your $thumber_dir 
		variable, which can be useful for, amongst other thing, setting a cute 
		"default" gallery that folk will see if they load thumber directy, 
		something which is usually possible. All the old methods still work 
		fine.

		To use site paths, simply set $thumber_dir to a path that starts with a 
		forward slash. e.g. $thumber_dir = '/imaging/Wallpaper/'; very much like 
		using the ?dir= GET variable.
	
	+	Improved -dir cannot be found- error message (and it's xhtml compliant!)

	~	Improved internal efficiency (progammer-speak for "lots of wee 
		changes that make stuff work better, easier to maintain").

	+	You can now set thumbs_dir before calling Thumber. You can now also set
		an /empty/ value for $thumbs_dir, so that thumbs will be created in the 
		same directory as the main images. 

		If you are embedding Thumber, and set $thumber_dir='', and 
		$thumbs_dir='', you would effectively be running Thumber with all 
		resources in the same directory as the embedding page (thumbs and 
		thumbs.ini).

	
	0.7.*

	+	Added a special $_GET variable you can use to force a thumbs rebuild 
		from your web browser. It's "rebuild". You can set a password, and then 
		simply do..
		
			http://yourdomain.com/path/to/thumber.php?rebuild=YourPassword

		and your thumbs+database will be rebuilt. Simple, but effective.

	*	killed warnings for the mkdir attempt; which will usually fail, anyway.
		


	0.6
		
	+	New ini reading/writing routines (mainly adapted from my ini-tools.php), 
		opening the way for more powerful ini features.

									*** IMPORTANT ***
	
					OLD THUMBS DATABASES MAY NO LONGER WORK CORRECTLY! 
								UNLESS YOU EDIT THIS PREF..

				$legacy_nfo='thumbs.nfo';	// the default setting

		..to the name of your old database files, probably 'thumbs.nfo'.

		That is ALL you have to do. Once that is correctly set, Thumber will 
		automatically and transparently update all your old databases to the new, 
		more comprehensve ini format (so long as it free to write the file).

		Actually, old galleries should *look* just fine even without any edits 
		or updating, but that would more likely be due to read-only conditions 
		and Thumber, being unable write new thumbs data, using the live 
		dimensions data from your images (so long as GD is available), along 
		with your old thumbs. To the user, there is no change, but you lose some 
		functionality (no auto-updating, etc.)

	~	Thumb info is now written after each thumbnail is created (rather than 
		writing them all at the end), so if something happens during a long 
		build, you will still have all the data created thus far. The next time 
		around, Thumber will just add new thumbs, as usual, effectively picking
		up where it left off.

	*	Deleted images will now be deleted from the database, too, as well as
		have their thumbnail removed.

	+	Thumber now checks the last modified time of all images, and stores
		this along with the size data. If an image gets modified in any way, a
		new thumb + database entry is automatically created for that image.



	0.5

	+	Can now be *easily* run embedded or self-contained, controlled by $_GET 
		variables. Thumber now correctly senses whether or not it is embedded, 
		and switches automatically.

		To embed and use the current directory (i.e. inside an index.php) use 
		$thumber_dir = '';

		Examples of both types of setup will be included.

	+	Improved titles, undescores also now replaced with spaces, so you can 
		use underscores in your actual file names (preferred, as you avoid any 
		warnings with malformed URLs) and still get pretty pop-up titles with 
		spaces in them.




	0.1-0.4

	~	Didn't keep much notes, sorree.




  ::2do::


		* Global thumbs root (do one chmod and forget!) - not so portable, but 
		useful for some.


	::for distro::

		* include exaple ini file (for folk that might need to do something 
		manually)



  ::bugs & foibles::

	
		If thumb exists, but (for some whacky reason) there is no database entry 
		- we should create one!


  ::TESTS::

		Remove an image		OK
		Add an image		OK
		Resize an image		erm.		could store file time - if updated - 
										update thumb. DON'T FORGET legacy_nfo


*/


?>