<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
								$csd_version = '0.4.1'; //	(HTML5 version)
/*
	simple source dump

	this simply dumps the source file to the screen using php's
	built-in "highlight_file" function, which probably requires
	at least php 4.2.

	We than transform the output to xhtml 1.0 strict, which I like.

	note: php5 now does this correctly, so if you have php5, you
	don't need this!

	usage:

		in your php script, at the bottom, probably..

		// direct access -> dump the php source..
		if ($_SERVER['SCRIPT_FILENAME'] == __FILE__) {
			@include $_SERVER['DOCUMENT_ROOT'].'/inc/source-dump.php';
			source_dump(__FILE__);
		}


	the option second parameter "embed" can be set to true..

		source_dump("/path/to/file.php", true);

	to just return the highlighted string as a string. You could drop
	it into any page with something like..

	<?php echo source_dump($_SERVER['DOCUMENT_ROOT'].'/server/src/rss/config.php', true); ?>

	The only advantage to using this as opposed to plain old highlight_file
	is that you get xhtml compliant source.

	I think it's a big advantage.

	;o) Cor

	(c) copyright corz.org 2003->today
*/


// You will need a local copy of this if you plan to support IE7/8 users..
$HTML5_shiv = '';	// $HTML5_shiv = '/inc/js/html5.js';

// for color prefs..
require_once $_SERVER['DOCUMENT_ROOT'].'/inc/init.php';


// see ya!
function source_dump() {
  global $csd_version, $site_scheme;
  $file = func_get_arg(0);
  if (func_num_args() > 1) { $embed = true; } else { $embed = false; }

	// php syntax highlighting..
	ini_set('highlight.string', $site_scheme['textview_string']);
	ini_set('highlight.comment', $site_scheme['textview_comment']);
	ini_set('highlight.keyword', $site_scheme['textview_keyword']);
	ini_set('highlight.bg', $site_scheme['bg_color']);
	ini_set('highlight.default', $site_scheme['textview_default']);
	ini_set('highlight.html', $site_scheme['textview_html']);

	$highlighted = highlight_file($file, true);

	// switch FONT tags to html5-friendly <span>
	// so, reading a source dump of *this* file, will fry your brain!
	$highlighted = str_replace('color="', 'style="color:', $highlighted);
	$highlighted = str_replace('font', 'span', $highlighted);

	if (!$embed) {
		$shiv_str = '';
		if (isset($HTML5_shiv)) {
		$shiv_str .= '
<!--[if lt IE 9]><script src='.$HTML5_shiv.'</script><![endif]-->';
		}
		die('<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="initial-scale=1.0, width=device-width" />'.$shiv_str.'
<title>php source dump of '.basename($file).' (courtesy of corz.org source dumper v'.$csd_version.')</title>
</head>
<body>
<div style="margin:5px">
	'.$highlighted.'
</div>
</body>
</html>');
	} else {
		return $highlighted;
	}
}

// direct access -> let's dump the php source!
if (realpath($_SERVER['SCRIPT_FILENAME']) == realpath(__FILE__)) { source_dump(__FILE__); }

?>