<?php	/* --- ۞---> text { encoding:utf-8;bom:no;linebreaks:unix;tabs:4sp; } */
															   $version = '0.4';
/*
	corz simple download counter

	This script enables you to keep track of a download.

	For more functionality, multiple counters, etc, see "corz distro machine".
	you may prefer this approach for one-page-one-download scenarios,
	essentially adding a single php function to your page, to deliver and count
	the downloads.

	To the user it works just the same as getting a file the regular way, except
	now we know how many times a file has been downloaded. you could potentially
	insert any routine into the process, like the counter is. You may want to
	display total downloads to the user, for instance.


	How it works:

	  This page sends a GET request to itself with the name of the file *in* the
	  request. When a download request arrives, it performs the go_download()
	  function, increases the counter by one, and then dies immediately.


	Installation:

	  Insert the three php parts into your page, top code, link, and function.


	For the link, inside php, just do..

		echo '<a href="',$_SERVER['SCRIPT_NAME'],'?download=somefile.zip,'">';

	Inside html do..

		<a href="<?php echo '$_SERVER['SCRIPT_NAME'],'?download=somefile.zip';?>


	The Counter File:

	For the counters to work, you'll need to have a file called .ht_downloads in
	the downloads folder (or somewhere). This file will need to be world-
	writeable. (chmod 777 or use your FTP client to set the permissions to ALL)

	Make Big Fun Now!

	;o) Cor

	(c) 2004->tomorrow! ~ cor + corz.org ;o)

	Please view the license for this free software, here:

		http://corz.org/free-scripts-licence.nfo
*/



/*
  This code goes at THE VERY TOP of your page. Yes, above the header.
																	*/
if (isset($_GET['download'])) {
	ini_set('zlib.output_compression','off');
	$file = str_replace('../','', @$_GET['download']);
	// not wise to keep .htaccess files in the same directory, but this will protect them..
	if (substr($file, 0, 1) == '.') { die('your bad'); }
	// Feel free to expand protection to other files you keep all-together with downloads!
	go_download($file);
	die;
}
/* 	Note:

	If you have zlib.output_compression set on your site (generally a smart
	idea) it's best to disable it for this folder (in the relevant .htaccess
	file) makes downloads go smoother, though they do work with it on, mostly.

	As a rule, I don't come out of php tags unless absolutely necessary. But
	you may have a different coding style or no style at all! So if you are not
	already inside php tags <?php ?>, you will need to add those around the
	code you insert into your page.
*/


/*
	Then, in your page, use a link something like this..

<?php echo '<a href="',$_SERVER['SCRIPT_NAME'],'?download=somefile.zip" title="download this file">somefile</a>'; ?>

	Here's one now..
*/

echo '<a href="',$_SERVER['SCRIPT_NAME'],'?download=somefile.zip" title="download this file">somefile</a>';

/*
	somefile.zip lives in the same folder as your page, though you could, of
	course, put it anywhere you like, perhaps in a protected subfolder. There's
	a wee note about this inside the function (below).
*/


// While we are here, for fun, we could spit out the current download count..
echo ' <code><small>(downloaded ',file_get_contents('.ht_downloads'),' times)</small></code>';


/*
	This function goes at the very bottom of your page..
*/
/*
function go_download()

	You can optionally send downlaod path and counter file path with your download file name:

		go_download (string {download file name)[, string {download path} [, string {counter file}]])

	Or you can hard-code other paths into the function, or both (where the hard-coded paths
	act as defaults, and sent parameters override).
*/
function go_download($download, $download_path='./', $counter_file='.ht_downloads') {

	//	specify a folder for the file './' = current folder

	/*	you MUST specify a path to a download, or else folks will send you page requests
		like  /page.php?download=/config.php  - you don't want that.	*/
	$file= $download_path.$download;

	// send the requested file to the user..
	header("Content-type: application/octet-stream");
	header("Content-disposition: attachment; filename=".$download);
	header("Content-Length: ".filesize($file)."\n");

    $get_it = fopen($file, 'rb');
    fpassthru($get_it);
	// you could also use readfile(), though both are prone to memory
	// issues with large files. I recommend spitting it out in chunks!

 	// now the counter..
	$count_file = $counter_file;
	if (file_exists($count_file)) {

		// read in the old score..
		$count = implode('', file($count_file));
		$count++;

		// the writing..
		$file_pointer = fopen($count_file, 'w+');
		fwrite($file_pointer, $count);
		fclose($file_pointer);
	}
}



/*
	itstory

	0.4
	Improved documentation, more beginner-friendly (mainly beginners use this!).

	Made counter file and download path configurable in the function call.

	Added example protection for .htaccess and similar files (surely you aren't
	putting this download script in amongst sensitive files!!!)


	0.3
	Improved security.


	0.2
	This has been more popular than I imagined, so I've imported some things I
	learned coding corz distro machine. importantly, we now DO send file sizes,
	and we DO disable zlib output compression, though you may still want to do
	that in some local .htaccess file (if it's enabled in the first place, that
	is)


	0.1
	ripped the function out of the corzoogle download page, put it out on its
	own
*/

