<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
if (realpath ($_SERVER['SCRIPT_FILENAME'] )   ==   realpath ( __FILE__ ))  {
										die ( 'to err is human, human!' ); }
/*

	"pj" a plug-in authentication module for pajamas	v0.8

	Usage:

		nothing is required to load the 'pj' module, it's the default.


	For full details, installation instructions, etc, see the accomanying
	readme. If you you got this without a readme, check out the link below.

	If you need help, mail me @ corz.org, or if you think the solution to your
	issue would be valuable to others, drop a comment on the pajamas page..

		http://corz.org/server/security/pajamas.php

	Have fun!

	;o) Cor

	ps..	Like all pajamas modules, the 'pj' module can also be accessed
			directly, if required.

	pps..	The client-side MD5 hashing is made possible by Paul Johnston's
			excellent JavaScript functions.. http://pajhome.org.uk/



	note:	to use this, you will need to have the javascript md5 functions,
			available in the demo, and here..

			http://corz.org/blog/inc/pajamas/modules/client-side/md5.js

	(c) corz.org 2004->today

*/



class authModule {

	var $_version			= '0.7.3.1';


/*	public properties..
	see the main pajamas engine for more details.
	*/
	var $_big_luser			= 10;
	var $_check_ip			= true;
	var $_createForms		= true;
	var $_do_messages		= true;
	var $_do_time_out		= true;
	var $_kick_bad_users	= false;
	var $_login_password	= 'password';
	var $_no_autocomplete	= true;
	var $_session_time		= 60;
	var $_code_location		= 'inc/pajamas/modules/client-side/md5.js';
	var $_error_catcher		= true;


	// private properties..
	var $_auth_message		= '';
	var $_bad_user			= false;
	var $_is_authenticated	= null;  // start out in unknown (unset) state
	var $_random_string		= '';
	var $_combined_hash		= '';
	var $_unique_id;

	var $_session_prefix	= 'sess_';

	// constructor:
	function authModule($uniqueid='') {
		if (!empty($uniqueid) and ctype_alnum($uniqueid)) {
			$this->_unique_id = $uniqueid;
		}
		if ($this->_error_catcher) {
			$this->startErrorHandler();
		}
		$this->initSession();
	}

	// main routine..
	function auth_user() {

		/*
			logic works like this:

			we only check if user is authenticated once per script execution.  It would be weird
			if $auth->auth_user() was called multiple times in a page and the session timed out halfway
			through the script.  This also saves a teensy bit of processing time.

			To do this, we need three states: null, true, and false.  null is unchecked.
		*/
		if ($this->_is_authenticated === true) {
			return true;
		} else if ($this->_is_authenticated === false) {
			return false;
		}


		/*
			Check for session clear..

										*/
		if (!empty($_POST['clear_session'])) {	// something strange happened to their session, so they cleared it
			$My_session_file = realpath(session_save_path()).'/'.$this->_session_prefix.session_id();
			unlink($My_session_file);
			sleep(1); // anti-anti-hammer!
			header("Location: ".$this->getSelf());
			$this->_is_authenticated = null;
			return false;
		}



		/*
		time-out
		do this before login events..	*/

		$time = '';
		$time_out = false;

		if ($this->_do_time_out == true) {
			$real_session_time = $this->_session_time * 6000;
			$now = explode(' ',microtime());
			$time = $now[1].substr($now[0],2,2);// 1/100th of a second
			settype($time, 'float');

			if (isset($_SESSION['auth'.$this->_unique_id]['login_at'])) {
				if ($_SESSION['auth'.$this->_unique_id]['login_at'] < ($time - $real_session_time)) {
					$this->_auth_message = 'session time-out!';
					$time_out = true;
				}
			}
		}

		/*
		you mindfully logged out..	*/

		if ((isset($_REQUEST['logout'])) or ($time_out == true)) {
			$this->endSession();
			if (isset($_POST['logout'])) { // you are posting, perhaps other data, too.
				unset($_POST['logout']);
//			} else { // must be a $_GET logout
//				if (!headers_sent()) {
//					header("Location: ".$this->getSelf()); // This gets rid of "logout" in the REQUEST vars,
//				} // *and* your posted comments, blog, etc. which is why it's only used for a $_GET logout.
			}
		}

		$agent_is_good = $address_is_good = false;
		$this->_random_string = $this->getRandomKey();

		/*
		check their IP address..	*/
		if ($this->_check_ip) {
			if (isset($_SESSION['auth'.$this->_unique_id]['remote_addr'])) {
				if ($_SERVER['REMOTE_ADDR'] == $_SESSION['auth'.$this->_unique_id]['remote_addr']) {
					$address_is_good = true;
				}
			} else {
				$_SESSION['auth'.$this->_unique_id]['remote_addr'] = $_SERVER['REMOTE_ADDR'];
			}
		} else { $address_is_good = true; }


		/*
		check their user agent..	*/

		if (isset($_SESSION['auth'.$this->_unique_id]['agent'])) {
			if (@$_SERVER['HTTP_USER_AGENT'] == $_SESSION['auth'.$this->_unique_id]['agent']) {
				$agent_is_good = true;
			}
		} else {
			$_SESSION['auth'.$this->_unique_id]['agent'] = @$_SERVER['HTTP_USER_AGENT'];
		}


		/*
		too many bad logins.
		they tried and tried, now we've had enough of them..	*/

		if (($_SESSION['auth'.$this->_unique_id]['count'] >= $this->_big_luser) and ($this->_kick_bad_users)) {
			$this->_bad_user = true;
			$this->_is_authenticated = false;
			// error message for lusers..
			$this->_auth_message = 'too many bad attempts! restart your browser to try again.';
			return false;
		}


		/*
		make a key	*/

		// we simply concatenate the password and random key to create a unique session md5 hash
		// I'll likely incorporate hmac into this in the near future.
		$this->_combined_hash = md5($this->_random_string.$this->_login_password);


		/*
		admin login
		someone has posted a password, it may be correct.	*/

		if (!empty($_POST['auth_login'])) {	// they went for it.

			if ($_POST['auth_login'] == $this->_combined_hash) {
				$_SESSION['auth'.$this->_unique_id]['login_at'] = $time; // isn't this empty ('')?
				$_SESSION['auth'.$this->_unique_id]['session_pass'] = md5($this->_combined_hash);
				$this->_is_authenticated = true;

			} else { // oh oh..

				$this->_auth_message = 'password incorrect!';
				$_SESSION['auth'.$this->_unique_id]['count']++;
				$_SESSION['auth'.$this->_unique_id]['key'] = $this->make_key();

				// they blew it.
				if ($_SESSION['auth'.$this->_unique_id]['count'] >= $this->_big_luser) {
					$_SESSION['auth'.$this->_unique_id]['dead'] = true; // just for our own records

					$this->_auth_message .= '<br />too many bad attempts! restart your browser to try again.';
					$this->_bad_user = true;
				}
				$this->_is_authenticated = false;
				return false;
			}
		}


		// already logged in..
		if (!empty($_SESSION['auth'.$this->_unique_id]['session_pass'])) {
			if ($_SESSION['auth'.$this->_unique_id]['session_pass'] == md5($this->_combined_hash)) {
				if ($address_is_good and $agent_is_good) {
					$this->_is_authenticated = true;
					return true;
				} else {
					$this->_is_authenticated = false;
					$this->_auth_message = '
			<div id="session-error">who are you? (something strange happened to your session)</div>
			<input tabindex="27000" type="submit" value="Clear Session"  id="clear_session" name="clear_session" />';
				}
			}
		}

		// all else failed.
		$this->_is_authenticated = false;
		return false;
	}


	function getAuthCode() {
		return '
<script src="'.$this->_code_location.'"></script>
<noscript>
	<div class="warning">This secure login facility requires javascript<br />
	please enable JavaScript in your browser, then refresh this page!</div>
</noscript>';
	}


	function getLoginForm() {

		if (func_num_args() > 0) {
			$simple = func_get_arg(0);
		} else {
			$simple = false;
		}
		$str = '';
		if ($this->_no_autocomplete) { $ac = 'autocomplete="off"'; } else { $ac = ''; }
		$method = 'onclick=';
		$activate = '"auth_login.value = calcMD5(\''.$this->getRandomKey().'\' + auth_login.value)"';

		if ($this->_createForms) {
			$str .= '
		<form id="passform" method="post" action="'.htmlspecialchars($this->getSelf()).'" onsubmit='.$activate.'>';
			$activate = '';
		} else {
			$activate = $method.$activate;
		}

		// instead of proprietary autocomplete, perhaps.. name="auth_login-'.$this->getRandomString().'"
		// and work out the $_POST variable later! hmm. dunno.
		if (!$simple) { $str .= '
		<div class="auth-container">
		<div class="auth-form">';
		}
		if (($this->_do_messages) and (!empty($this->_auth_message))) {
			$str .= '
		<div class="warning">'.$this->_auth_message.'</div><br />';
		}

		$str .= '
			<span class="auth-text">password..</span><br />
			<input tabindex="27001" type="password" class="auth-login" id="auth_login" autofocus="autofocus" name="auth_login" title="watch this area VERY carefully when you click \'log in\'" '.$ac.' />
			<input tabindex="27002" type="submit" value="login" title="on some systems you MUST click this, pressing enter won\'t work" '.$activate.' /><br />';

		if (!$simple) { $str .= '
			<div class="auth-note">';
			$cs = '';
		} else {
			$cs = ' class="auth-note"';
		}
		$str .= '
				<a'.$cs.' href="http://corz.org/server/security/pajamas.php" onclick="window.open(this.href); return false;" title="php and javascript advanced md5 authentication system, from corz.org">powered by pajamas authentication</a>';

		if (!$simple) { $str .= '
			</div>
		</div>
		</div>';
		}
		if ($this->_createForms) { $str .= '
		</form>';
		}

	return $str;
	}

/*
	create logout button..
*/
	function getLogoutButton() {

		if (func_num_args() > 0) {
			$simple = func_get_arg(0);
		} else {
			$simple = false;
		}

		$str = '';
		if ($this->_createForms) {
			$str = '
		<form id="logout_form" action="'.htmlspecialchars($this->getSelf()).'" method="post">';
		}
		if (!$simple) {
			$str .='
		<div class="auth-logout">';
		}
		$str .='<input tabindex="27003" type="submit" id="pajamas_logout" value="logout" name="logout" />';
		if (!$simple) {
			$str .='</div>';
		}
		if ($this->_createForms) {
			$str .= '
		</form>';
		}
		return $str;
	}


	function getSelf() {
		$qsa = '';
		if (!empty($_SERVER['QUERY_STRING'])) $qsa .= '?'.$_SERVER['QUERY_STRING'];
		return $_SERVER['SCRIPT_NAME'].$qsa;
	}


	function getBadUser() {
		return $this->_bad_user;
	}


	function endSession() {
		unset($_SESSION['auth'.$this->_unique_id]);
		$this->initSession();
	}


	function initSession() {
		/*
			If an error ocurrs when starting the session, it's either E_NOTICE if a session already exists
			or E_WARNING if headers were already sent, so session exists doesn't matter and won't appear
			anyway, but headers sent which does matter will appear.  Otherwise you won't know why the script
			isn't working...

			Then again, if you call the header line later, you'll see "headers already sent" a second time.
		*/
		if (!headers_sent()) {
			@session_start();
			header('Cache-control: private'); // IE 6 Fix :/
		}

		// initialize the session variables..
		if (!isset($_SESSION['auth'.$this->_unique_id])) {
			$_SESSION['auth'.$this->_unique_id] = array('count' => 0);
		}
	}


	function getRandomKey() {
		// already created a random key for this user?..
		if (!empty($_SESSION['auth'.$this->_unique_id]['key'])) {
			return $_SESSION['auth'.$this->_unique_id]['key'];
		} else { // a new visitor..
			return $_SESSION['auth'.$this->_unique_id]['key'] = $this->make_key();
		}
	}

/*
	function make_key

	create a random 32 character string. this will be their new session key (salt)
	you could make this a *lot* more random, an md5 of some uniqid(rnd()) function,
	or something. I just enjoy lower case letters, that's all, and really, once
	you start to play with numbers this big (ie. the possible combinations), it's
	fairly academic which characters you use.
*/
	function make_key() {
		$this->_random_string = '';
		for($i=0;$i<32;$i++) { $this->_random_string .= chr(rand(97,122)); }
		return $this->_random_string;
	}


/*
	a simple session error catcher..
	*/
	function getErrors() {
		return $GLOBALS['errors']['pajamas'];
	}
	function startErrorHandler() {
		set_error_handler(array($this, 'handle_error'));
	}
	function handle_error($type, $string, $file, $line, $vars) {
		switch (true) {
			case ($type == 8 and stristr($string, 'session')):
				if (empty($GLOBALS['errors']['pajamas'])) { $GLOBALS['errors']['pajamas'] = ''; }
				$GLOBALS['errors']['pajamas'] .= 'NOTICE! session error on line '.$line.' of '.$file.': '.$string;
				return true;
				break; // *ahem*
			default:
				return false; // better let php handle this one.
		}
	}


}/*
end::authModule	*/



class simpleAuthModule extends authModule {

	function simpleAuthModule($uniqueid='') {
		parent::authModule($uniqueid);
		echo $this->getAuthCode();
		if ($this->auth_user()) {
			echo $this->getLogoutButton();
		} else {
			echo $this->getLoginForm();
		}
	}

}

/*

	changes.

	0.7.3

		all <input> elements have been given a tabindex

	0.7.2

		If you were previously logged in and "Something strange happened to your
		session", a button is output, to Clear the session.

	0.7.1

		Fixed an isse where query strings weren't being appended to the form's
		'action' parameter.

	0.7

		Altered the logout routine slightly..

		Previously, when you logout, all the $_REQUEST variables were unset, but if you
		login and logout on a page where you are posting comments, blogging, etc. you would
		lose your content. that is now fixed.

		If you *desire* this behaviour, use a simple $_GET logout, ie. a link, like this..

			page.php?logout=true

		instead of a regular form button. You will logout as normal, and get a fresh page,
		minus the  "?logout=whatever" part.


		Fixed a bug where could log yourself out unintentionally..

		I made some adjustments to the login logic. It should now more accurately ascertain
		if you really did mean to send a password or not. This allows better intergration
		with other forms (previously, if you posted on a page with a login form, but didn't
		actually login yet, each POST would count towards your "bad login count")



	0.6..

		pajamas plug-in release.

*/


?>