<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
if (realpath ($_SERVER['SCRIPT_FILENAME'] )   ==   realpath ( __FILE__ ))  {
										die ( 'to err is human, human!' ); }
/*

	"plain"
	a plug-in authentication module for pajamas.

	If, for some insane reason, you don't have access to a JavaScript-capable
	browser, use this 'plain' module, otherwise, use 'pj'. You could feasibly
	allow users to choose, I guess. :/

	The plain module has many of its features of the more secure 'pj' module;
	sessions, IP check, time-out, etc., and can be configured in exactly the
	same way as, too. The only real difference being that the password is sent
	over the wire in *plain* text. JavaScript is not required.

	With the pajamas plain module, at least the password travels over the wires
	one time only, unlike HTTP basic authentication, which send the password with
	*every single request*! Probably that's what your site hosting admin uses,
	crazy, huh.

	Usage:

		simply load pajamas as usual. ie..

			include '/path/to/pajamas.php';
			$auth = new pajamas();

		or

			$auth = new pajamas('MyUid'); // optionally pass an id


		and then, before you use the module, with your other preferences, set..

			$auth->_default_module = 'plain';

	If you need to use the plain module in 'simple' mode, set that inside pajamas,
	or else call it like this.. $auth = new pajamas('uid-plain');

	If you need help, mail me @ corz.org, or if you think a solution to your
	issue would	be valuable to others, drop a comment on the pajamas page.

		http://corz.org/server/security/pajamas.php

	Have fun!

	;o) Cor

	ps..	Like all pajamas modules, the plain module can also be accessed
			directly, if required.

	© 2006->today ~ cor @ corz.org ;o)

*/


class authModule {

	var $_version			= '0.1.1';


/*	public properties..
	see the main pajamas engine for more details.
	*/
	var $_big_luser			= 10;
	var $_check_ip			= true;
	var $_createForms		= true;
	var $_do_messages		= true;
	var $_do_time_out		= true;
	var $_kick_bad_users	= false;
	var $_login_password	= 'password';
	var $_no_autocomplete	= true;
	var $_session_time		= 60;


	// private properties..
	var $_auth_message		= '';
	var $_bad_user			= false;
	var $_is_authenticated	= null;
	var $_unique_id;


	// constructor..
	function authModule($uniqueid='') {
		if (!empty($uniqueid) and ctype_alnum($uniqueid)) {
			$this->_unique_id = $uniqueid;
		}
		$this->initSession();
	}

	// main function..
	function auth_user() {

		if ($this->_is_authenticated === true) {
			return true;
		} else if ($this->_is_authenticated === false) {
			return false;
		}

		$address_is_good = false;
		if ($this->_check_ip == false) { $address_is_good = true; }
		$agent_is_good = false;


		$time = '';
		$time_out = false;
		if ($this->_do_time_out == true) {
			$real_session_time = $this->_session_time * 6000;
			$now = explode(' ',microtime());
			$time = $now[1].substr($now[0],2,2);
			settype($time, 'float');

			// time-out (do this before login events)..
			if (isset($_SESSION['auth'.$this->_unique_id]['login_at'])) {
				if ($_SESSION['auth'.$this->_unique_id]['login_at'] < ($time - $real_session_time)) {
					$this->_auth_message = 'session time-out!';
					$time_out = true;
				}
			}
		}


		// you logged out..
		if ((isset($_REQUEST['logout'])) or ($time_out == true)) {
			$this->endSession();
			// This gets rid of the logout in the REQUEST vars
			if (!headers_sent()) {
				header("Location: ".$this->getSelf());
			}
		}

		// check their IP address..
		if (isset($_SESSION['auth'.$this->_unique_id]['remote_addr'])) {
			if ($_SERVER['REMOTE_ADDR'] == $_SESSION['auth'.$this->_unique_id]['remote_addr']) {
				$address_is_good = true;
			}
		} else {
			$_SESSION['auth'.$this->_unique_id]['remote_addr'] = $_SERVER['REMOTE_ADDR'];
		}

		// check their user agent..
		if (isset($_SESSION['auth'.$this->_unique_id]['agent'])) {
			if ($_SERVER['HTTP_USER_AGENT'] == $_SESSION['auth'.$this->_unique_id]['agent']) {
				$agent_is_good = true;
			}
		} else {
			$_SESSION['auth'.$this->_unique_id]['agent'] = $_SERVER['HTTP_USER_AGENT'];
		}

		// they tried and tried, now we've had enough of them..
		if (($_SESSION['auth'.$this->_unique_id]['count'] >= $this->_big_luser) and ($this->_kick_bad_users)) {
			$this->_bad_user = true;
			$this->_is_authenticated = false;

			// error message for lusers..
			$this->_auth_message = 'too many bad attempts! restart your browser to try again.';
			return false;
		}


		// admin login
		if (isset($_POST['auth_login'])) {	// u da man!

			if ($_POST['auth_login'] == $this->_login_password) {
				$_SESSION['auth'.$this->_unique_id]['login_at'] = $time; // isn't this empty ('')?
				$_SESSION['auth'.$this->_unique_id]['session_pass'] = md5($this->_login_password);
				$this->_is_authenticated = true;

			} else { // oh oh..
				$_SESSION['auth'.$this->_unique_id]['count']++;
				$this->_auth_message = 'password incorrect!';

				// they blew it.
				if ($_SESSION['auth'.$this->_unique_id]['count'] >= $this->_big_luser) {
					$_SESSION['auth'.$this->_unique_id]['dead'] = true; // just for our own records

					$this->_auth_message = 'too many bad attempts! restart your browser to try again.';
					$this->_bad_user = true;
				}
				$this->_is_authenticated = false;
				return false;
			}
		}


		// already logged in..
		if ((isset($_SESSION['auth'.$this->_unique_id]['session_pass']))
			and ($_SESSION['auth'.$this->_unique_id]['session_pass'] == md5($this->_login_password))) {
			if (($address_is_good == true) and ($agent_is_good == true)) {
				$this->_is_authenticated = true;
			} else {
				$this->_auth_message = 'who are you?';
			}
		}
		return $this->_is_authenticated;
	}

	function getAuthCode() {
		return '';
	}

	function getLoginForm() {

		if (func_num_args() > 0) {
			$simple = func_get_arg(0);
		} else {
			$simple = false;
		}
		$str = '';
		if ($this->_no_autocomplete) { $ac = 'autocomplete="off"'; } else { $ac = ''; }

		if ($this->_createForms) {
			$str .= '
		<form name="passform" method="post" action="'.$this->getSelf().'">';
		}

		// instead of proprietary autocomplete, perhaps.. name="auth_login-'.$this->getRandomString().'"
		// and work out the $_POST variable later! hmm. dunno.
		if (!$simple) { $str .= '
		<div class="auth-container">
		<div class="auth-form">';
		}
		if (($this->_do_messages) and (!empty($this->_auth_message))) {
			$str .= '
		<div style="color:#FF0000;font-weight:bold;">'.$this->_auth_message.'</div><br />';
		}

		$str .= '
			<span class="auth-text">password..</span><br />
			<input type="password" class="auth-login" id="auth_login" name="auth_login" size="16" autofocus="autofocus" title="watch this area VERY carefully when you click \'log in\'" '.$ac.' />
			<input type="submit" value="login" title="note: on weird systems you MUST click this, pressing enter won\'t work" /><br />';

		if (!$simple) { $str .= '
			<div class="auth-note">';
			$cs = '';
		} else {
			$cs = ' class="auth-note"';
		}
		$str .= '
				<a'.$cs.' href="http://corz.org/server/security/pajamas.php" onclick="window.open(this.href); return false;" title="php and javascript advanced md5 authentication system, from corz.org">powered by pajamas authentication (plain)</a>';

		if (!$simple) { $str .= '
			</div>
		</div>
		</div>';
		}
		if ($this->_createForms) { $str .= '
		</form>';
		}

	return $str;
	}

/*
	create logout button..
*/
	function getLogoutButton() {

		if (func_num_args() > 0) {
			$simple = func_get_arg(0);
		} else {
			$simple = false;
		}

		$str = '';
		if ($this->_createForms) {
			$str = '
		<form name="logout_form" action="'.$this->getSelf().'" method="post">';
		}
		if (!$simple) {
			$str .='
		<div class="auth-logout">';
		}
		$str .='<input type="submit" value="logout" id="pajamas_logout" name="logout" />';
		if (!$simple) {
			$str .='</div>';
		}
		if ($this->_createForms) {
			$str .= '
		</form>';
		}
		return $str;
	}



	function getSelf() {
		$qsa = '';
		if (!empty($_SERVER['QUERY_STRING'])) $qsa .= '?'.$_SERVER['QUERY_STRING'];
		return $_SERVER['SCRIPT_NAME'].$qsa;
	}

	function getBadUser() {
		return $this->_bad_user;
	}

	function endSession() {
		unset($_SESSION['auth'.$this->_unique_id]);
		$this->initSession();
	}

	function initSession() {

		if (!headers_sent()) {
			session_start();
			header('Cache-control: private'); // IE 6 Fix :/
		}

		// initialize the session variables..
		if (!isset($_SESSION['auth'.$this->_unique_id])) {
			$_SESSION['auth'.$this->_unique_id] = array('count' => 0);
		}
	}

}


class simpleAuthModule extends authModule {

	function simpleAuthModule($uniqueid='') {
		parent::authModule($uniqueid);
		if ($this->auth_user()) {
			echo $this->getLogoutButton();
		} else {
			echo $this->getLoginForm();
		}
	}

}


// GD security image verification.
//
class verificationImage {


	 // / / /  /   /   /    /     /       /
	// public properties..

	// width of image..
	var $_width = 125;

	// that other dimension.
	var $_height = 50;


	/*
		truecolor image

		probably requires GD2 to use truecolor, but looks better.
		having said that, the jaggedy lines of an 8-bit image may
		actually be preferable, here. your call..
	*/
	var $_truecolor = true;


	/*
		image format

		chose from 'png', 'jpeg', or 'gif'. clearly png is superior,
		though, as above, this may not be what you want.
	*/
	var $_img_format = 'png';


	/*
		colors for the semi-transparent foiling strings..
		use regular HTML hex values. the "#" is optional.
	*/
	var $_color_1 = '#FF80FF'; // magenta  '#FF80FF'
	var $_color_2 = '#FFFF00'; // yellow '#FFFF00'
	var $_color_3 = '#80FFFF'; // cyan '#80FFFF'

	/*
		translucency of foiling strings..
		0-127 (127 is completely transparent)
	*/
	var $_translucency = 42;


	/*
		truetype font

		this must live in the same folder as this script
		or else be in some way accessible to php.
		(see ampsig[.com] default scheme for more details)

		default is 'profont.ttf', a neat, mono, free truetype font
		designed especially for coding. I use it all over.
		a more fancy font may be preferable (harder to machine-read)
	*/
	var $_font_face = 'profont.ttf';


	// point size of tt font
	var $_font_size = 20;


	// skew angle of text..
	var $_angle = 20;


	// how long a string?
	// (default: 5 characters)
	var $_text_length = 5;


	/*
		allow an incorrect entry to "de-verify" a verified user.
		just for the demo. normally they would verify, and that's it.
		but for the demo, folk will want to play with it.
	*/
	var $_allow_deverify = false;


	/*
		string generation flavour.
		choose from 'md5',  'masher', or 'mish-mash'..

		'masher' creates a random string of lower-case letters.

		'md5' plucks a short segment from an MD5 hash, a mix of
		lower-case letters a-f, plus numbers, eg 'ac5e3b'.

		'mish-mash' is my favourite, creating a nice wide mix of
		alpha-numerics, eg 'mG2tU'.
	*/
	var $_verify_flavour = 'mish-mash';




	 // / / /  /   /   /    /     /       /
	// private..

	var $_text = '';
	var $_img = null;
	var $_is_verified = null;


	// da constructor..
	function verificationImage() {
		// just in case..
		@session_start();
		if ($this->_allow_deverify == false) {
			if (isset($_SESSION['gd_verify'])) {
				$this->_is_verified = $_SESSION['gd_verify'];
			}
		}
	}


	function getVerification() {

		if ($this->_is_verified === true) {
			return true;
		}
		if ($this->_is_verified === false) {
			return false;
		}

		if (isset($_POST['gd_string'])) {
			if ($this->verify_string($_POST['gd_string'])) {
				$_SESSION['gd_verify'] = $this->_is_verified = true;
				return true;
			} else { // demo..
				if ($this->_allow_deverify) {
					$_SESSION['gd_verify'] = $this->_is_verified = false;
					return false;
				}
			}
		}

		$_SESSION['gd_verify'] = null;
		return;
	}


	function make_string() {

		$string = '';

		switch($this->_verify_flavour) {

			case 'md5':
				$string = substr(md5(mt_rand()), 12, $this->_text_length);
				break;

			case 'masher':
				for($i = 0; $i < $this->_text_length ; $i++) {
					$string .= chr(mt_rand(97,122)); // lower-case
				}
				break;

			case 'mish-mash':
				$strings = array();
				for($i = 0; $i < $this->_text_length ; $i++) {
					$strings[] = chr(mt_rand(97,122)); // lower-case
					$strings[] = chr(mt_rand(65,90)); // UPPER-CASE
					$strings[] = chr(mt_rand(48,57)); // 0123456789
				}
				$pluck = array_rand($strings, $this->_text_length);
				foreach ($pluck as $key => $value) {
					$string .= $strings[$key];
				}
				break;
		}

		$_SESSION['img_str'] = $string;
		return $string;
	}


	// do they match?..
	function verify_string($img_str) {
		if ($_SESSION['img_str'] === $img_str) {
			return true;
		} else {
			return false;
		}
	}

	function doInput() {
		return '<input type="text" name="gd_string" /> ';
	}


	function outputImage() {

		// some text..
		$this->_text = $this->make_string();

		// start with a blank image..
		if ($this->_truecolor) {
			$this->_img = imagecreatetruecolor($this->_width, $this->_height);
		} else {
			$this->_img = imagecreate($this->_width, $this->_height);
		}

		// colours we shall use..
		$white = imagecolorallocate($this->_img, 255, 255, 255);
		$this->_background_color = imagecolorallocate($this->_img, 255, 247, 209);
		$dark = imagecolorallocate($this->_img, 33, 33, 33);

		$one = $this->hex2dec($this->_color_1);
		$color_1 = imagecolorallocatealpha($this->_img, $one[0], $one[1], $one[2], $this->_translucency);

		$two = $this->hex2dec($this->_color_2);
		$color_2 = imagecolorallocatealpha($this->_img, $two[0], $two[1], $two[2], $this->_translucency);

		$three = $this->hex2dec($this->_color_3);
		$color_3 = imagecolorallocatealpha($this->_img, $three[0], $three[1], $three[2], $this->_translucency);

		// background..
		// probably we want to put shapes and shit in here..
		imagefilledrectangle($this->_img, 0, 0, $this->_width, $this->_height, $this->_background_color);

		// rotate the text around its centre..
		// yes, we could simply calculate the centre point and lay it there, but this is not only a
		// wee bit more clever, but introduces nice unpredictable displacement based on letter size.

		$x = $this->_width / 1.93;
		$y = $this->_height / 2.5; // ttf's calculate from baseline, this sorta compensates. a tweaker!

		// get the boundingbox..
		$bbox = imagettfbbox($this->_font_size, $this->_angle, $this->_font_face, $this->_text);

		// calculate deviation..
		$dx = (($bbox[2]-$bbox[0]) / 2) - (($bbox[2]-$bbox[4]) / 2);
		$dy = (($bbox[3]-$bbox[1]) / 2) + (($bbox[7]-$bbox[1]) / 2);

		// our new pivot points..
		$px = $x - $dx;
		$py = $y - $dy;

		// we only need a small variation here
		$var_x = rand(4, 7);
		$var_y = rand(4, 7);

		// put the text string onto the image in a few different colours..
		imagettftext($this->_img, $this->_font_size + 2, $this->_angle, $px-$var_x, $py - 5 - $var_y, $color_2, $this->_font_face, $this->_text);
		imagettftext($this->_img, $this->_font_size + 2, $this->_angle, $px - 12 - $var_x, $py, $color_1, $this->_font_face, $this->_text);
		imagettftext($this->_img, $this->_font_size + 2, $this->_angle, $px + 3 + $var_x, $py + $var_y, $color_3, $this->_font_face, $this->_text);

		// now the *real* text..
		imagettftext($this->_img, $this->_font_size, $this->_angle, $px, $py, $dark, $this->_font_face, $this->_text);

		// border..
		imagefilledrectangle($this->_img, 0, 0, $this->_width, 0, $dark);
		imagefilledrectangle($this->_img, $this->_width - 1, 0, $this->_width - 1, $this->_height - 1, $dark);
		imagefilledrectangle($this->_img, 0, 0, 0, $this->_height - 1, $dark);
		imagefilledrectangle($this->_img, 0, $this->_height - 1, $this->_width, $this->_height - 1, $dark);

		// finally, spit it out..
		header('Content-type: image/'.$this->_img_format);

		switch ($this->_img_format) {
			case 'png':
				imagepng($this->_img);
			case 'jpg':
				imagejpeg($this->_img);
			case 'gif':
				imagegif ($this->_img);
			break;
		}
		imagedestroy($this->_img);
	}

	/*
	convert an HTML #hex colour to decimal colour levels..	*/
	function hex2dec($rgb) {
		if (substr($rgb, 0, 1) == "#") {
			$rgb = substr($rgb, 1);
		}
		$r = hexdec(substr($rgb, 0, 2));
		$g = hexdec(substr($rgb, 2, 2));
		$b = hexdec(substr($rgb, 4, 2));
	return array($r, $g, $b);
	}

}


?>