<?php // ۞// text { encoding:utf-8;bom:no;linebreaks:unix;tabs:4sp; }
if (realpath ($_SERVER['SCRIPT_FILENAME']) == realpath (__FILE__))  {
    /*  deny direct access  */   die ( 'to err is human, human!' ); }
/*

	PHP implementation of the Secure Hash Algorithm (SHA-1) 
	[as defined in FIPS PUB 180-1]

	Use when php's sha1() is not available on your server.
	(Last modified: Friday Mar 31, 2006 ;o)

	This code is available under the Lesser GNU:
	http://www.gnu.org/licenses/lgpl.txt

	Modified by Jerome Clarke (sinatosk@gmail.com) 1st Oct 2004

	Based on the PHP implementation by Marcus Campbell..
	http://www.tecknik.net/sha-1/

	Which was in turn adapted from Paul Johnston's JavaScript 
	implementation.. http://pajhome.org.uk/ 

	Finally, ironically, it gets coupled back with Paj's 
	JavaScript code in the pajamas "shaggie" plug-in..

		http://corz.org/server/security/pajamas.php
*/

// second parameter for php5 compatability.
function sha1($str, $raw_output=false) { 
	if ($raw_output === true) { 
		return pack('H*', sha1($str, false));
	}

	$x = sha1_str2blks_SHA1($str);
	$a =  1732584193;
	$b = -271733879;
	$c = -1732584194;
	$d =  271733878;
	$e = -1009589776;

	$x_count = count($x);

	for ($i = 0; $i < $x_count; $i += 16) {
		$olda = $a;
		$oldb = $b;
		$oldc = $c;
		$oldd = $d;
		$olde = $e;

		for ($j = 0; $j < 80; $j++) {
			$w[$j] = ($j < 16) ? $x[$i + $j] : sha1_rol($w[$j - 3] ^ $w[$j - 8] ^ $w[$j - 14] ^ $w[$j - 16], 1);

			$t = sha1_safe_add(sha1_safe_add(sha1_rol($a, 5), sha1_ft($j, $b, $c, $d)),
				sha1_safe_add(sha1_safe_add($e, $w[$j]), sha1_kt($j)));
			$e = $d;
			$d = $c;
			$c = sha1_rol($b, 30);
			$b = $a;
			$a = $t;
		}

		$a = sha1_safe_add($a, $olda);
		$b = sha1_safe_add($b, $oldb);
		$c = sha1_safe_add($c, $oldc);
		$d = sha1_safe_add($d, $oldd);
		$e = sha1_safe_add($e, $olde);
	}

	return sprintf('%08x%08x%08x%08x%08x', $a, $b, $c, $d, $e);
}


// auxiliary functions.. 
function sha1_str2blks_SHA1($str) {

	$strlen_str = strlen($str);
	$nblk = (($strlen_str + 8) >> 6) + 1;
	for ($i=0; $i < $nblk * 16; $i++) {
		$blks[$i] = 0;
	}
	for ($i=0; $i < $strlen_str; $i++) {
		$blks[$i >> 2] |= ord(substr($str, $i, 1)) << (24 - ($i % 4) * 8);
	}

	$blks[$i >> 2] |= 0x80 << (24 - ($i % 4) * 8);
	$blks[$nblk * 16 - 1] = $strlen_str * 8;

	return $blks;
}

function sha1_safe_add($x, $y) {
	$lsw = ($x & 0xFFFF) + ($y & 0xFFFF);
	$msw = ($x >> 16) + ($y >> 16) + ($lsw >> 16);

	return ($msw << 16) | ($lsw & 0xFFFF);
}

function sha1_rol($num, $cnt) {
	return ($num << $cnt) | sha1_zeroFill($num, 32 - $cnt);   
}

function sha1_zeroFill($a, $b) {
	$bin = decbin($a);
	$strlen_bin = strlen($bin);
	$bin = $strlen_bin < $b ? 0 : substr($bin, 0, $strlen_bin - $b);
	for ($i=0; $i < $b; $i++) {
		$bin = '0'.$bin;
	}
	return bindec($bin);
}

function sha1_ft($t, $b, $c, $d) {
	if ($t < 20) return ($b & $c) | ((~$b) & $d);
	if ($t < 40) return $b ^ $c ^ $d;
	if ($t < 60) return ($b & $c) | ($b & $d) | ($c & $d);

	return $b ^ $c ^ $d;
}

function sha1_kt($t) {
	if ($t < 20) return 1518500249;
	if ($t < 40) return 1859775393;
	if ($t < 60) return -1894007588;

	return -899497514;
}

?>