<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
if  (realpath ($_SERVER['SCRIPT_FILENAME'])    ==    realpath (__FILE__))  {
                                        die ( 'to err is human, human!' ); }
/*
	corzblog functions	v2.3

	a part of corzblog.. http://corz.org/blog/

	;o) Cor

	(c) copyright 2003->today -> cor @ corz.org

	notes:

		file functions..

		For line-breaks; Mac uses "\r", Windows uses "\r\n", and UNIX uses "\n".

		I use UNIX line-breaks across the board, for all text storage. Even Windows
		web servers can understand them, in .htaccess files, wherever.

		So, if you open an ini file and it looks like it's all one one line, or
		something, you need to get yourself a decent text editor..

			http://corz.org/corz/faq.php#utf8

*/


	/*
		 text functions..
							*/


// a nice, validating "jump to"..
function do_cbtimer () {
	return '
<script>
//<![CDATA[
<!--
function jsPause(seconds, url) {
	setTimeout( function() {
		window.location = url;
	}, seconds * 1000 );
}
//-->
//]]>
</script>
<noscript><!-- Window Relocation - JavaScript Only --></noscript>';
}



// used to activate the above
function make_jump_link($jump_string, $time, $url, $do_link, $link_str) {

	// flat links..
	if ($GLOBALS['corzblog']['rewrite_links'] and stristr($url, 'archive=')) {
		$url = $GLOBALS['corzblog']['blogzpath'].substr($url,strpos($url,'=')+1);
	}


	$link_string = '
			<div class="centered">';

	if ($do_link) {
		$link_string .= '
				<noscript>
				<a href="'.$url.'" title="'.$link_str.'" id="nonjsbloglink">'.$link_str.'</a>
				</noscript>';
	}
	$link_string .= '
				<script>
				//<![CDATA[
				<!--
					document.write("<small><a href=\"'.$url.'\" title=\"'.$jump_string.'\">'.$jump_string.'<\/a><\/small>");
					jsPause('.$time.', \''.$url.'\');
				//-->
				//]]>
				</script>
				<noscript><!-- Jump Link - JavaScript Only --></noscript>
			</div>';

	return $link_string;
}





// re-usable warning messages..
//
// $sub is *usually* created by make_jump_link()
function do_message($main, $sub, $warning=false, $go_back=false) {

	$id_str = 'message';
	if ($warning) { $id_str = 'warning'; }
	$tring = '
		<div class="message">
			<div id="'.$id_str.'">
				'.$main.'
			</div>';
	if (!empty($sub)) {
		$tring .= '
			'.$sub;
	}
	$tring .= '
		</div>';
	if ($go_back) { $tring .= do_back_butt(); }
	return $tring;
}




// a nice "back" button..	// this never actually happens!
function do_back_butt() {
	return '
		<div class="centered">
			<noscript>
				<small>(press your back button to return to the edit page)</small>
			</noscript>
			<script>
			//<![CDATA[
			<!--
				document.write("<form id=\"warnform\" method=\"post\" action=\"\"><div><input title=\"this button needs javascript\" type=\"button\" name=\"back\" value=\" go back \" onclick=\"javascript:history.go(-1)\" \/><\/div><\/form>");
			//-->
			//]]>
			</script>
			<noscript><!-- Button is JavaScript Only --></noscript>
		</div>';
}



/*
mail masher..

it's handy to keep this here. used to encode your email address
so the spam-bots don't chew on it.

if you need a "mashed" email address somewhere on your site, include this,
and do.. href="<?php echo mashed_mail('email@address.com'); ?>" in your link
note: there are now [email] and [murl] bbcode tags specifically for this.

see http://corz.org/engine for more stuff like this.
							*/
function mashed_mail($addy) {

	for ($i=0;$i<strlen($addy);$i++) { $letters[] = $addy[$i]; }

	while (list($key, $val) = each($letters)) {
		$r = rand(0,20);
		if ($r > 9) { $letters[$key] = '&#'.ord($letters[$key]).';'; }
	}
	$mashed_email_addy = implode('', $letters);
	$mashed_email_addy = 'mailto:'.$mashed_email_addy;
	return $mashed_email_addy;

}


/*
  make a valid "id"
							  */
function do_valid_id ($title) {
	$title = str_replace(' ', '-', strip_tags($title));
	$id_title = preg_replace("/[^a-z0-9-]*/i", '', $title);
	while (is_numeric((substr($id_title, 0, 1))) or substr($id_title, 0, 1) == '-') {
		$id_title = substr($id_title, 1);
	}
	return trim(str_replace('--', '-',$id_title));
}


// trim slashes from a string, or else don't..
function do_slashes($string) {
	if (get_magic_quotes_gpc()) {
		return trim(stripslashes($string));
	} else {
		return trim($string);
	}
}



/*
	"tokens"

	transform '/blog/page.php' into '{path}page.php', and vice versa.

	we want to present (and save) tokens wherever possible.
	not only is it more portable, but it's easier on the user, too.
												  */
function tokenize_links($links_array, $direction) {
	foreach($links_array as $my_link => $link_array) {
		$new_links = $link_array;
		$new_links['text'] = switch_tokens($new_links['text'], $direction);
		$new_links['url'] = switch_tokens($new_links['url'], $direction);
		$new_links['title'] = switch_tokens($new_links['title'], $direction);
		$new_array[$my_link] = $new_links;
	}
	if (isset($new_array) and is_array($new_array)) { return $new_array; }
	return array();
}


// switch user tokens for real paths..
// ensure all characters are valid html characters.
function switch_tokens($tring, $direction) {

	if ($direction != 'decode') {

		/* going the long way around this has several advantages, enabling not only
		token words embedded within tokens, but plain and pre-tokenised text can have
		new tokens added manually, and transformed automatically, with no intervention.	*/
		$tring = str_replace('{url}',		'+++++*u*r*l*+++++',		$tring);
		$tring = str_replace('{path}',		'++++*p*a*t*h*++++',		$tring);
		$tring = str_replace('{about}',		'+++*a*b*o*u*t*+++',		$tring);
		$tring = str_replace('{email}',		'+++*e*m*a*i*l*+++',		$tring);
		$tring = str_replace('{mysite}',	'++*m*y*s*i*t*e*++',		$tring);
		/* if your {mysite} was "site", the word being inside {mysite}. it would be
		transformed into "{my{mysite}}". This section prevents that sort of thing happening. */

		/*
		here are the actual transformations..	*/
		$tring = str_replace($GLOBALS['corzblog']['blog_url'],		'{url}',		$tring);
		$tring = str_replace($GLOBALS['corzblog']['blogzpath'],		'{path}',		$tring);
		$tring = str_replace($GLOBALS['corzblog']['about_link'],	'{about}',		$tring);
		$tring = str_replace($GLOBALS['corzblog']['mail_addy'],		'{email}',		$tring);
		$tring = str_replace($GLOBALS['corzblog']['mysite'],		'{mysite}',		$tring);

		$tring = str_replace('+++++*u*r*l*+++++',		'{url}',		$tring);
		$tring = str_replace('++++*p*a*t*h*++++',		'{path}',		$tring);
		$tring = str_replace('+++*a*b*o*u*t*+++',		'{about}',		$tring);
		$tring = str_replace('++*m*y*s*i*t*e*++',		'{mysite}',		$tring);
		$tring = str_replace('+++*e*m*a*i*l*+++',		'{email}',		$tring);

	} else {

		// this only happens when we actually create links on the page..

		$tring = str_replace('{url}',		$GLOBALS['corzblog']['blog_url'],		$tring);
		$tring = str_replace('{path}',		$GLOBALS['corzblog']['blogzpath'],		$tring);
		$tring = str_replace('{about}',		$GLOBALS['corzblog']['about_link'],		$tring);
		$tring = str_replace('{email}',		'++++email++++',						$tring);
		$tring = htmlspecialchars($tring); // "+" *is* an html special character.
		$tring = str_replace('++++email++++', $GLOBALS['corzblog']['mashed_addy'],	$tring);
		$tring = str_replace('{mysite}',	$GLOBALS['corzblog']['mysite'],			$tring);
	}

	return $tring;
}



/*
	Spit out a standard doctype statement

	HTML5 now. saves repetition.
	note. <head> tags on your page (see right below)
					*/
function doc_type() {
	echo '<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="initial-scale=1.0, width=device-width" />';
	echo '
<meta name="description" content="',$GLOBALS['corzblog']['mysite_clean'],'.. ',strip_tags($GLOBALS['corzblog']['description']),'" />
<meta name="generator" content="http://corz.org/engine?download=corzblog.zip" />
<meta name="author" content="http://corz.org" />
<meta name="publisher" content="',$GLOBALS['corzblog']['host'],'" />
<meta name="robots" content="all" />
<link title="',$GLOBALS['corzblog']['mysite_clean'],' news feed [RDF/RSS 1.0]" type="application/rss+xml" rel="alternate" href="http'.$GLOBALS['prot_add'].'://',$GLOBALS['corzblog']['host'],$GLOBALS['corzblog']['blogzpath'],'rdf.php" />
<link title="',$GLOBALS['corzblog']['mysite_clean'],' news feed [RSS 0.91]" type="application/rss+xml" rel="alternate" href="http'.$GLOBALS['prot_add'].'://',$GLOBALS['corzblog']['host'],$GLOBALS['corzblog']['blogzpath'],'rss.php" />';
if (isset($GLOBALS['corzblog']['html5_shiv']) and !empty($GLOBALS['corzblog']['html5_shiv'])) {
	echo '
<!--[if lt IE 9]><script src="',$GLOBALS['corzblog']['html5_shiv'],'"></script><![endif]-->';
}
if ($GLOBALS['corzblog']['ga_code']) {
	echo '
<script>
	var _gaq = _gaq || [];
	var pluginUrl =
	\'//www.google-analytics.com/plugins/ga/inpage_linkid.js\';
	_gaq.push([\'_require\', \'inpage_linkid\', pluginUrl]);
	_gaq.push([\'_setAccount\', \'',$GLOBALS['corzblog']['ga_code'],'\']);
	_gaq.push([\'_trackPageview\']);
</script>
<noscript><!-- google analytics - PLEASE enable JavaScript! This stuff helps the site! --></noscript>';
} // the rest of the GA code is in the footer - it runs quicker that way.

//	include $GLOBALS['corzblog']['path'].'/inc/metadata.php';
	if (file_exists($GLOBALS['corzblog']['custom_metadata'])) { include $GLOBALS['corzblog']['custom_metadata']; }
	cb_stop_watch('start');
}

// or we could use..
// <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">



// include style sheets..
function output_style_links() {
	if ($GLOBALS['corzblog']['site_css'] != '') {
		$style_sheets = explode(',', $GLOBALS['corzblog']['site_css']);
		foreach ($style_sheets as $my_sheet) {
			echo '
<link rel="stylesheet" href="',$my_sheet.'?colors='.$GLOBALS['corzblog']['current_scheme_name'],'" type="text/css" media="screen" />';
		}
	}
	echo '
<link rel="stylesheet" href="',$GLOBALS['corzblog']['blogzpath'],
	'inc/themes/',$GLOBALS['corzblog']['current_theme'],'/',$GLOBALS['corzblog']['style_sheet'].
		'?colors='.$GLOBALS['corzblog']['current_scheme_name'],'" type="text/css" media="screen" />';

}



function blog_header($title, $description) {
	return '
	<div id="header" onclick="window.location=\'/\'">
		<div id="headerback"></div>
		<div id="cb-header">'.$title.'</div>
		<div id="site-description">'.$description.'</div>
	</div>';
}


// spit out footer..
function do_foot() {
	include 'inc/footer.php';

	echo '
</div>
<div class="clear"></div>';

	// custom footer..
	if ($GLOBALS['corzblog']['custom_footer']) { include $GLOBALS['corzblog']['custom_footer']; }

}




// see ya!
function die_message($string) {
	die(doc_type().'<head>
<title>you may go now</title>
</head>
<body>
<div id="die-message"><br />
	'.$string.'
</div>
</body>
</html>');
}





	/*
		 blog file functions..
								*/


/*
	function grab_blogs()

	grab the blog file into a string.
	if it's missing, we attempt to create a new file (utf-8, with unix linebreaks).
										*/
function grab_blogs($blog_file) {
//$GLOBALS['errors']['grab_blogs: input'] = "input file: $blog_file!";//:debug

	// just in case..
	if (empty($blog_file)) {
		$GLOBALS['errors']['grab_blogs'] = '$blog_file wasn\'t specified!';
		return false;
	}

	// attempt to create a new file..
	if (!file_exists($blog_file)) {
		$GLOBALS['errors']['grab_blogs'] = '$blog_file doesn\'t exist!';
		return false;
	}

	// init..
	$blog_data = '';

	if (is_readable($blog_file)) {
		if (filesize($blog_file) > 0) { // possibly we recently archived
			if ($fp = fopen($blog_file, 'rb')) {
				$lock = flock($fp, LOCK_SH);
				if ($lock) {
					$blog_data = fread($fp, filesize($blog_file));
					$lock = flock($fp, LOCK_UN);
				} else {
					$GLOBALS['errors']['grab_blogs'] = "can't lock $blog_file!";
					return false;
				}
				fclose($fp);
			}
			return $blog_data;
		} else {
			$GLOBALS['errors']['grab_blogs'] = "$blog_file is empty!";
			return false;
		}
	} else {
		$GLOBALS['errors']['grab_blogs'] = "can't read $blog_file!";
		return false;
	}
}




/*
	function get_blog_entries()

	grab all the blogs from the blog file into an array of blogs
										*/
function get_blog_entries($blog_file) {

	if (empty($blog_file)) { return false; }

	// not a blog file..
	if (substr($blog_file, - strlen($GLOBALS['corzblog']['blog_ext'])) != $GLOBALS['corzblog']['blog_ext']) {
		return false;
	}

	// legacy corzblog entries..
	if ($blog_data = grab_blogs($blog_file)) {
		if (strstr($blog_data, '<end>')) {
			$blog_data = x_update($blog_file);
		}
		// split it into an array..
		$blogfile_parts = explode('<!--*end*-->', $blog_data);

		// trim empties..
		$limit = count($blogfile_parts);
		for ($i=0; $i<$limit; $i++) {
			if ((trim($blogfile_parts[$i])) == '') { unset($blogfile_parts[$i]); }
		}

		// return the array..
		return $blogfile_parts;

	} else {
		// grab_blogs returned false. oh dear.
		$GLOBALS['errors']['get_blog_entries'] = $GLOBALS['errors']['grab_blogs'];
		unset($GLOBALS['errors']['grab_blogs']);
		return false;
	}
}



/*
	get blog parts..

	split up the blog and return an array of meaningful parts
	(extra steps for clarity)

		usage: array get_blog_parts( string (complete blog entry) )

	"parts" returned..

		[0]	blog body
		[1]	title
		[2]	id title
		[3]	raw title (includes HTML tags)
		[4] plain text part of "posted by" line

									 */
function get_blog_parts($blog_entry) {

	$blog_entry = trim($blog_entry);
	if (empty($blog_entry)) { return false; }

	// split the blog..
	$blog_parts = explode('<!--*g*-->', $blog_entry);

	// as it comes, for display..
	if (!empty($blog_parts[1])) {
		$raw_title = $blog_parts[1];
	} else {
		return false;
	}

	// a plain version of the title
	// generally used inside pop-up titles and form fields
	$title = trim(strip_tags($raw_title));

	// valid version, for id's..
	$id_title = do_valid_id($title);

	// split this out for transformation..
	if (!empty($blog_parts[3])) {
		$posted_by = trim(strip_tags($blog_parts[3]));
	} else {
		return false;
	}

	// the (3rd) part between <!--*g*-->2  &  <!--*g*-->3
	// is the meat of the blog..
	if (!empty($blog_parts[2])) {
		$blog_body = $blog_parts[2];
	} else {
		return false;
	}

	// return the array of parts..
	return array($blog_body, $title, $id_title, $raw_title, $posted_by);
}




/*
	prepend a blog to the blog file..
	aka. add to the top
										   */
function add_blog ($blog_file, $blog_data) {

	// the file exists?
	if (!file_exists($blog_file)) {
		create_blank();
	}

	$old = grab_blogs($blog_file);
	$blog_data .= $old;

	if (is_writable($blog_file)) {
		if ($fp = fopen($blog_file, 'w+')) {
			$lock = flock($fp, LOCK_EX);
			if ($lock) {
				fwrite ($fp, $blog_data);
				flock ($fp, LOCK_UN);
				fclose ($fp);
				clearstatcache();
			} else { $GLOBALS['errors']['add_blog'] = $blog_file.' can\'t be locked!'; }
		}
	} else {
		$GLOBALS['errors']['add_blog'] = $blog_file.' is not writable!';
		$GLOBALS['corzblog']['admin_warning'][] = array("WARNING: $blog_file is read-only!",
		'edit its permissions to make it writable (<code>chmod 777</code>),, then refresh this page', true);
		$GLOBALS['state'] = 'preview';
	}
}



// what? no blog file?
function create_blank() {

	$blog_file = $GLOBALS['corzblog']['blog_file'];

	// attempt to create a new file..
	if (!file_exists($blog_file)) {
		write_blog($blog_file, "\n");
	}

	if (!file_exists($blog_file)) {
		$GLOBALS['corzblog']['admin_warning'][] = array('the blog file "'.$blog_file.'" doesn\'t exist!', 'please create a file called "'.$blog_file.'" (no quotes) inside your main corzblog folder, and set its permissions to world writable (in a shell: chmod 777 /path/to/blog/blogz.blog .. or use your FTP client to set its permissions to ALL.)', true);
		$GLOBALS['errors']['grab_blogs'] = 'the blog file "'.$blog_file.'" doesn\'t exist!';
		return false;
	}
}

/*
	create a blog entry
								*/
function create_blog_entry ($blog_title, $blog_body, $posted_by) {
		$entry = '
<div class="blog-entry">
<div id="'.do_valid_id($blog_title).'">
<!--*g*-->
<h1>'.$blog_title.'</h1>
<!--*g*-->'.$blog_body.'<!--*g*-->
</div>

<div class="byline">
	'.$posted_by.'
</div>
<hr class="cb-hr" /><br />
</div>

';
	return $entry;
}




/*
	write out a complete blog file..
									   */
function write_blog($blog_file, $data, $ignore_fail=false, $do_backup=false) {

	if (!is_writable($blog_file)) { // try and create it..
		$fp = @fopen($blog_file, 'wb');
	}

	if (is_writable($blog_file)) {

		// normally, the calling function will take care of this (see do_backup())
		if ($do_backup) {
			// backup, for when called to write non-blogs, prefs and such..
			$bakfile = dirname($blog_file).'/backup/'.basename($blog_file);
			if (!copy($blog_file, $bakfile)) {
				$GLOBALS['errors']['write_blog'] = "failed to backup $file!";
			}
		}
		//
		if ($fp = fopen($blog_file, 'wb')) {
			$lock = flock($fp, LOCK_EX);
			if ($lock) {
				fwrite ($fp, $data);
				flock ($fp, LOCK_UN);
				fclose ($fp);
				clearstatcache();
				return true;
			} else {
				$GLOBALS['errors']['write_blog'] = "$blog_file can't be locked!";
				return false;
			}
		}
	} else {
		if ($ignore_fail) { return false; }
		$GLOBALS['errors']['write_blog'] = "$blog_file is not writable!";
		$GLOBALS['state'] = 'preview';
		$GLOBALS['corzblog']['admin_warning'][] = array("WARNING: $blog_file is read-only!",
			'Edit its permissions to make it writable (<code>chmod 777</code>), then refresh this page', true);
		return false;
	}
}


/*
the user has decided to call their "blog" files by another name. *sigh*
hahah! this is cool, not only will it switch the extension of your
blog and about files, but all your archives, too.

Everything is backed-up, and it only takes a moment.

												*/
function switch_blognames($old_name, $new_name) {

	if (!strpos($new_name, '.')) { // also true if dot is first character, unlike strstr()
		$GLOBALS['corzblog']['admin_warning'][] = array('The blog file name <em>must</em> &nbsp;have an extension!',
			'"something<span class="big">.</span>somethingelse"', true);
		return false;
	}

	$errors_str = $copy_errors  = '';

	// what was the old naming scheme?
	$old_name_parts = (explode('.', $old_name));
	$old_ext = $old_name_parts[1];

	$new_name_parts = (explode('.', $new_name));
	$new_ext = $new_name_parts[1];

	// attempt to rename files..
	if (!rename_blog($old_name, $new_name)) {
		$copy_errors .= $old_name;
	}

	if (!rename_blog($GLOBALS['corzblog']['about_name'].'.'.$old_ext, $GLOBALS['corzblog']['about_name'].'.'.$new_ext)) {
		$copy_errors .= $GLOBALS['corzblog']['about_name'].'.'.$old_ext;
	}

	// what about the archives..
	$arc_files_array = return_dir($GLOBALS['corzblog']['archive_dir'], '.'.$old_ext);

	// if archives can't be renamed, we will proceed, but give a warning.
	foreach($arc_files_array as $file) {
		$arc_name_parts = (explode('.', $file)); $arc_name = $arc_name_parts[0];
		if (!rename_blog($GLOBALS['corzblog']['archive_dir'].$file, $GLOBALS['corzblog']['archive_dir'].$arc_name.'.'.$new_ext)) {
			$errors_str .= '<strong>Warning:</strong> couldn\'t rename '.$file.' to '.$arc_name.'.'.$new_ext.'. ';
		}
	}

	if (!empty($copy_errors)) {
		$GLOBALS['errors']['switch_blognames'] = 'There were errors switching the following blog files..'.$copy_errors;
		return false;

	} elseif (!empty($errors_str)) {
		$GLOBALS['corzblog']['admin_warning'][] = array($errors_str,
			'please check your permissions inside '.$GLOBALS['corzblog']['archive_dir'].', and rename these archives manually', true);
	}

	// you went all the way!
	return true;
}



// rename a blog file for some reason..
function rename_blog($oldname, $newname) {

	$backup = false;

	// nothing to rename..
	if (!file_exists($oldname)) {
		$GLOBALS['corzblog']['admin_warning'][] = array($oldname.' doesn\'t exist!', 'Something is definitely not right here!', true);
		return false;
	}

	// make a back-up..
	if (do_backup($oldname)) { $backup = true; }

	// destination file exists..
	if (file_exists($newname)) {
		$GLOBALS['corzblog']['admin_warning'][] = array($newname.' already exists!', 'Check your permissions', true);
		return false;
	}

	if (rename($oldname, $newname)) {
		if (file_exists($newname)) {
			if (!$backup) {
				$notice = 'NOTE: although the rename was successful, the back-up process was not. please check the permissions inside '.$GLOBALS['corzblog']['archive_dir'].' folder.';
			} else { $notice = ''; }

			// success!
			return true;

		} else {
			$GLOBALS['corzblog']['admin_warning'][] = array('Somehow, '.$newname.' does not exist.', 'Go figure!', true);
			return false;
		}
	} else {
		$GLOBALS['corzblog']['admin_warning'][] = array('I cannot rename '.$corzblog['blog_file'].' to '.$newname.'.',
			'Please do it manually, or fix your permissions and try again.', true);
		return false;
	}
}


// make a back-up of a blog..
function do_backup($filename, $bax_dir='backup') {

	$backupdir = $GLOBALS['corzblog']['archive_dir'].$bax_dir;
	$error =  array('I couldn\'t create the backup directory',
		'please check the permissions of '.$GLOBALS['corzblog']['archive_dir'].' folder.', true);

	if (!file_exists($backupdir)) {

		if (@mkdir($backupdir)) {
			// a new backup dir, let's make an .htaccess..
			create_htaccess($backupdir, 2);
		} else {
			$GLOBALS['corzblog']['admin_warning'][] = $error;
		}

		if (file_exists($backupdir)) {
			$backupdir = $GLOBALS['corzblog']['archive_dir'].$bax_dir.'/';
		} else {
			$backupdir = $GLOBALS['corzblog']['archive_dir'];
		}
	} else { $backupdir .= '/'; }

	// it may already be *in* the archive folder..
	$new_name = str_replace($GLOBALS['corzblog']['archive_dir'], '', $filename);

	if (@copy($filename, $backupdir.$new_name.'.bak')) {
		return true;
	} else {
		$GLOBALS['errors']['do_backup'] = "couldn't back-up $filename!";
		$GLOBALS['corzblog']['admin_warning'][] = $error;
		return false;
	}
}



	/*
		 arc functions..
							*/



/*
	parse archive folder

		array ( string (path to directory), string (archive file extension) )

	returns an array of available archives on success..

	    [itemz] => Array
        (
            [2004] => Array
                (
                    [3] => apr
                    [4] => dec
                    [5] => feb
                    [6] => jan
                )
			)

	returns false on failure.
										   */
function parse_arc_dir($arc_dir, $blog_ext) {

	$itemz = array();
	if ($raw_dir = return_dir($arc_dir, $blog_ext)) {
		foreach($raw_dir as $file) {
			$file_year = substr($file, 0, strpos($file, '-'));
			$file_month = substr($file, strpos($file, '-') + 1, -strlen($blog_ext)); // chop off ".blog"
			$itemz[$file_year][] = $file_month;
		}
		if (!empty($itemz)) { return $itemz; } else { return false; }
	} else { return false; }
}



/*
get the raw list of blog files from a folder of blogs and return as an array of file names
											*/
function return_dir($arc_dir, $blog_ext) {

	if ($thearc = @opendir($arc_dir)) {

		while (false !== ($file = readdir($thearc))) {
			/*
			show only .blog files, not files beginning with a dot (".")
				(for instance, mac resource files:  ._2004-mar.blog)
			*/
			if ((substr($file, -(strlen($blog_ext))) == $blog_ext) and (ord($file) != 46)) {
				$itemz[] = $file;
			}
		}

		// now we have all the .blog files in one array
		closedir($thearc);
		if (!empty($itemz)) { return $itemz; } else { return false; }

	} else {
		// couldn't open the dir.
		$arc_dir = substr($arc_dir, 0, -1);
		$GLOBALS['corzblog']['admin_warning'][] = array('the archive folder "'.$arc_dir.'" doesn\'t exist!',
		'please create a folder called "'.$arc_dir.'" (no quotes) inside your main corzblog folder.', true);
		$GLOBALS['errors']['parse_arc_dir'] = 'archive folder "'.$arc_dir.'" doesn\'t exist!';
		return false;
	}
}




/*

	a few combo prefs for the admin page..
											*/

/*
	Return a list of available themes as an array.

	pass (false) to skip the validation check, which basically checks to see if there is a valid css file where it
	should be.

	In that case, get_themes() will return a list of all the top-level subdirectories inside your "themes" directory.
									*/
function get_themes($validate=true) {
	$themes = array();
	$basedir = $GLOBALS['corzblog']['path'].'/inc/themes';
	if ($themesdir = @opendir($basedir)) {
		while (false !== ($dir = readdir($themesdir))) {
			switch ($validate) {
				case true:
					if ( @file_exists($basedir.'/'.$dir.'/'.basename($dir).'.css') ) {
						$themes[] = $dir;
					}
					break;
				case false:
					if ( @is_dir($basedir.'/'.$dir) and (ord($dir) !== 46) ) {
						$themes[] = $dir;
					}
					break;
			}
		}
		closedir($themesdir);
		return $themes;
	} else {
		return array();
	}
}


// current schemes list
function get_schemes() {
	return array_keys(grab_ini($GLOBALS['corzblog']['path'].'/inc/themes/'.$GLOBALS['corzblog']['current_theme'].'/'.$GLOBALS['corzblog']['current_theme'].'.ini'));
}


// return all the file names in a directory as an array, ignoring any *.nfo files..
//
function get_word_lists($basedir) {
	if ($wordlists_dir = @opendir($basedir)) {
		while (false !== ($file = readdir($wordlists_dir))) {
			if ( !is_dir($basedir.'/'.$file) and (ord($file) !== 46) and substr(strrchr($file, "."), 1) != 'nfo' ) {
				$lists[] = $file;
			}
		}
		closedir($wordlists_dir);
		return $lists;
	} else {
		return array();
	}
}



// return an array of all the top-level directories inside the /blog/ folder
//
function get_dirs($basedir) {
	if ($top_dir = @opendir($basedir)) {
		while (false !== ($dir = readdir($top_dir))) {
			if ( is_dir($basedir.'/'.$dir) and (ord($dir) !== 46) and $dir != 'inc') {
				$dirs[] = $dir;
			}
		}
		closedir($top_dir);
		return $dirs;
	} else {
		return array();
	}
}



/*
	sort the archives into some
	meaningful order..
							   */
function sort_archives($itemz) {

	if (empty($itemz)) {
		$GLOBALS['errors']['sort_archives'] = '"'.$itemz.'" is empty!';
		return false;
	}

	$dirsize = count($itemz);
	krsort($itemz);
	foreach($itemz as $key => $value ) {

		// re-index the month arrays..
		$months = array_values($itemz[$key]);
		$month_ref = array('jan','feb','mar','apr','may','jun','jul','aug','sep','oct','nov','dec');
		$nice_months = array();

		// sort the months into the correct order..
		// not exactly clever, but very effective.
		foreach($month_ref as $good_month) {
			foreach($months as $wonky_month) {
				if ($wonky_month == $good_month) {
					$nice_months[] = $good_month;
				}
			}
		}
		krsort($nice_months);
		// in-case you mixed month and non-month archive names..
		foreach($months as $wonky_month) {
			if (!in_array($wonky_month, $month_ref) and (!in_array($wonky_month, $nice_months))) {
				$nice_months[] = $wonky_month;
			}
		}

		// in-case you didn't use months at all!
		if (empty($nice_months)) { $nice_months = $months; }
		//:2do (shall we sort the months b4 adding?

		// loop through the available archives..
		foreach($nice_months as $blogzname ) {
			$sorted_months[$key][] = $blogzname;
		}
	}
	return $sorted_months;
}



/*
	create a drop-down of all the available archives..

												  */
function do_archive_drop_down($archiv_dir, $blog_ext) {

	// best to create an array, to get *all* the files..
	$itemz = parse_arc_dir($archiv_dir, $blog_ext);
	$sorted = sort_archives($itemz);

	// don't bother if there's no archives..
	if (isset($sorted) and is_array($sorted)) {
		if (count($sorted) > 0) {
			echo '
					<label for="arc-name">
					<select name="arc-name" id="arc-name">';
			foreach($sorted as $key => $value ) { // loop through the sections (usually years)..
				echo '
						<optgroup label="',$key,'">';
				foreach($sorted[$key] as $blogzname ) { // loop through the available archives..

					$i = 0;
					$blog_entries = get_blog_entries($archiv_dir.$key.'-'.$blogzname.$blog_ext);
					$month = substr($blogzname, strpos($blogzname, '-'));

					foreach($blog_entries as $blog) {
						$parts = get_blog_parts($blog);
						if (strlen($parts[1]) > 50) $parts[1] = substr($parts[1], 0, 50).' &hellip; ';
						echo '
								<option value="',$key,'-',$blogzname,'-',$i,'">',$month,': ',$parts[1],'</option>';
						$i++; // we simly need a value we can parse into the correct blog entry.
					}
				}
			echo '
							</optgroup>';
			}
			echo '
					</select></label>';
		}
	}
}


/*
spit out a drop-down list of blog entries in any file..	*/
function drop_down($blog_file) {
	$i = 0;
	$blog_entries = get_blog_entries($blog_file);
	if (!$blog_entries) return;
	foreach($blog_entries as $blog) {
		$parts = get_blog_parts($blog);
		echo '
					<option value="',$i,'">',$parts[1],'</option>';
		$i++;
	}
}



/*

	2do.. delete this! like 5 years ago!

	upgrade an old corzblog 2 entry to corzblog 3 format

	we simply convert the splitter tags (so we can create menus, etc.)
	and let cbparser handle any legacy html in the entries themselves.

	this happens the instant an old blog is accessed. if you want the
	legacy blog entry itself to be xhtml 1.0 strict, simply run it
	through the editor one time, and it will be so.
							   */
function x_update ($blog_file) {

	$blog_data = grab_blogs($blog_file);
	$old_tags = array(
		'<end>',
		'<g>',
		'<hr size=1 width="70%" align=left><br />',
		'<div class="byline">',
		'<p id=');
	$new_tags = array(
		"<!--*end*-->\n\n",
		'<!--*g*-->',
		"<hr class=\"cb-hr\" /><br />\n</div>",
		"</div>\n<div class=\"byline\">",
		"<div class=\"blog-entry\">\n<div id=");
	$blog_data = str_replace($old_tags, $new_tags, $blog_data);
	write_blog($blog_file, $blog_data);
	return grab_blogs($blog_file);
}



/*
grab the data from an ini file	*/
function grab_ini($ini_file, $section=null) {

	if (!file_exists($ini_file)) {
		if (!write_cb_ini($ini_file, array())) { // attempt to create it.
			$GLOBALS['corzblog']['admin_warning'][] = array('ini file "'.$ini_file.'"cannot be written!',
				'please make the data folder writable!', true);
		}
	}

	// there should be an .htaccess file next to the ini, to deny direct access to the files.
	// we will check if it exists, and if not, we shall attempt to create it..
	create_htaccess(dirname($ini_file), 2); // type 2: deny from all

	// okay, let's grab the prefs..
	if (file_exists($ini_file)) {
		$config_array = parse_ini_file($ini_file, true);
		if ($section and array_key_exists($section, $config_array)) { return $config_array[$section]; }
		return $config_array;
	} else {
		return false;
	}
}

/*
// ensure ini file is cached..
function grab_ini_cached ($ini_file, $sections=null) {
    ob_start();
    include $ini_file;
    $tring = ob_get_contents();
    ob_end_clean();
    return parse_ini_string($tring, $sections);
}

*/


/*
function write_ini()

	accepts an array of values, and creates an "ini" file from them.
	you can send it multi-dimensional arrays and it will create [sections]

	usage:

		bool ( string{string path to file}, array{array of ini values} )

	this function returns true on success,
	false on failure.
											  */
function write_cb_ini($data_file, $cfg_array) {

	$data = ";  ۞  text { encoding: utf-8 ; bom: no ; linebreaks: unix ; tabs: 4sp ; }
;
; corzblog ini file
;
";
	if (stristr($data_file, 'links')) {
		$data .= "; you can use \"tokens\" in any part of your link.
; possible tokens:
;
;	{token}		=>		transforms to..
;
;	{url}		=>		the full URI of your blog
;	{path}		=>		the path from server root to your blog, eg \"/blog/\"
;	{about}		=>		the name of your \"about\" page, usually \"about\"
;	{mysite}	=>		the name of your blog site. mine is, unsurprisingly, \"corzblog\"
;	{email}		=>		your \"mashed\" email address, eg.. {email}?subject={mysite}
;
;	NOTE: You can also hack in special properties to links by way of the \"props\" setting, like so..
;
;		[configure]
;		url = \"{path}admin.php\"
;		title = \"{mysite} configuration\"
;		props = \"onmouseover=&quot;this.style.backgroundColor='#FFFF00'&quot; onmouseout=&quot;this.style.backgroundColor='transparent'&quot;\"
;
;	NOTE: Remember to use HTML Entities for quotes and such, corzblog will convert them to real quotes at run-time.
;
;	NOTE: If you edit your links from the admin GUI, all this happens automatically.
;

";
	} else {
		$data .= "; all values go inside \"\" quotes.
; boolean values are either \"on\" (enabled) or empty \"\" (disabled)
;
";	}

	foreach($cfg_array as $key => $section) {

		if (is_array($section)) {
			$data .= "[".make_clean_key($key)."]\n";
			foreach( $section as $cfg => $val) {
				$val = str_replace('"', '&quot;', $val);
				//$val = str_replace('"', '\"', $val);	// new for php 5.3 - escaped quotes
				$data .= $cfg." = \"".$val."\"\n";
			}
			$data .= "\n";	// linebreak between sections
		} else {
			$section = str_replace('"', '&quot;', $section);
			$data .= $key." = \"".$section."\"\n";
		}
	}

	if (get_magic_quotes_gpc()) {
		$data = stripslashes($data);
	}

	if (write_blog($data_file, $data, false, true)) {
		return true;
	} else {
		if (isset($GLOBALS['errors']['write_blog'])) {
			$GLOBALS['errors']['write_cb_ini'] = $GLOBALS['errors']['write_blog'];
			unset($GLOBALS['errors']['write_blog']);
		}
		return false;
	}

	return true;
}


// sanitize a string for use in an ini [key]
//
function make_clean_key($tring) {
	$search = explode(',', '?,{,},|,&,~,!,[,],(,),^,",;');
	return addslashes(str_replace($search, '', $tring));	// addslashes for apostrophes
}



/*
	stop-watch

	a good place to start the page generation timer..
	send it 'start' (or any positive value), to start it up,
	anything else to get back a float of the time difference
	since the stop-watch was started..
						  */
function cb_stop_watch () {
	if (func_num_args() > 0) { $press = func_get_arg(0); }
		else { $press = false; }

	static $start_time;
	$time = array_sum(explode(' ', microtime(true)));

	if (!empty($press)) { $start_time = $time; }
		else { return ($time - $start_time); }
}



/*
	create an .htaccess file.

	type 1.	main /blog/.htaccess
	type 2. deny all (used for data folders)

											*/
function create_htaccess($file_path, $type) {

	if (!file_exists($file_path.'/.htaccess')) {

		switch($type) {

			case 1:
				$ht_str = '
# # # # # # # # # # # # # # # # # # # # # # # # # #
                                                  #
# # # # # # # # # # # # # # # # # # # # # # # # # #
#
#	corzblog main /.htaccess
#
# # # # # # # # # # # # # # # # # # # # # # # # # #
                                                  #
# # # # # # # # # # # # # # # # # # # # # # # # # #
#
#	file types setup..
#
#	for php as regular apache module..
#	(for phpsuexec (aka. cgi) use, set this in a local php.ini file)
#
<ifmodule mod_php4.c>
	php_value default_charset utf-8
</ifmodule>
<ifmodule mod_php5.c>
	php_value default_charset utf-8
</ifmodule>
#
#	on windows servers, you may have to comment out the <ifmodule> lines.
#
#	this isn\'t totally necessary, but with this set, if anyone accessed
#	your blog file directly they would at least see basic html formatting.
#
#	phpsuexec safe!
#
<FilesMatch "\.(blog|comment)$">
    SetHandler application/x-httpd-php
</FilesMatch>
#
#	at the foot is a rule to prevent EXACTLY this! uncomment if required.
#
# # # # # # # # # # # # # # # # # # # # # # # # # #
                                                  #
# # # # # # # # # # # # # # # # # # # # # # # # # #
#
#	permalinking rules.
#
#	you can access your corzblogs like this.. http://domain.com/blog/2003-oct
#	and this..  http://corz.org/blog/2004-sep/sheesh for individual entries
#
#	your permalink rewrites rules should work fine from inside *this* folder..
#
rewriteengine on
rewriterule ^([_a-z0-9]+)-([_a-z0-9-]+)/?(.+)? index.php?archive=$1-$2&blog=$3 [nc,l]
#
#	if not, comment these out and try something like this in your *main* .htaccess..
#
#rewriteengine on
#rewriterule ^blog/([_a-z0-9]+)-([_a-z0-9-]+)/?(.+)? http://mydomain.com/blog/index.php?archive=$1-$2&blog=$3 [nc]
#
# # # # # # # # # # # # # # # # # # # # # # # # # #
                                                  #
# # # # # # # # # # # # # # # # # # # # # # # # # #
#
#	prevent direct access to your .blog files..
#
#rewriterule ^(.*)\.blog /blog/ [r,nc]
#
#
#
#	always leave a spare empty line at the bottom of .htaccess files.
';
				break;


			case 2:
				$ht_str= '
#
#  a part of corzblog
#
deny from all
';
				break;
		}//:end switch:

		if (write_blog($file_path.'/.htaccess', $ht_str, true)) {
			return true;
		} else {
			if (isset($GLOBALS['errors']['write_blog'])) {
				$GLOBALS['errors']['create_htaccess'] = $GLOBALS['errors']['write_blog'];
				unset($GLOBALS['errors']['write_blog']);
			}
			return false;
		}
	} else {
		// it exists.
		return false;
	}
}





/*
	The Sidebar
	nifty in places
						*/

function sidebar() {

	global $corzblog, $perma_view;

	if (func_num_args() > 0) { $prefs = func_get_arg(0); }
	if (!isset($prefs)) { $prefs = $GLOBALS['corzblog']; }

	ob_start();

	echo '
<!-- sidebar -->
<div class="sidebar">';

	// main links..
	echo '
	<nav>
	<h1>Sidebar Navigation</h1>
	<div title="main blog links.." class="links">
		<h2>',$prefs['main_menu_name'],'</h2>
		<ul>';

	$prefs['main_links'] = tokenize_links($prefs['main_links'], 'decode');

	foreach($prefs['main_links'] as $my_url => $my_properties) {

		if (!empty($my_properties['title'])) {
			$url_title = strip_tags($my_properties['title']);
		} else {
			$url_title = '';
		}

		// yes..
		$do_link = true;

		// check for secure (https) links first
		if (substr($my_properties['url'], 0, 1) == '!') {
			$my_properties['url'] = substr($my_properties['url'], 1);
			$my_properties['url'] = str_replace('http:','https:', $my_properties['url']);
		}

		// admin-only links..
		if (substr($my_properties['url'], 0, 1) == '#') {
			$my_properties['url'] = substr($my_properties['url'], 1);
			if (!$corzblog['is_authorized']) { $do_link = false; }
		}

		// visitor-only links..
		if (substr($my_properties['url'], 0, 1) == '@') {
			$my_properties['url'] = substr($my_properties['url'], 1);
			if ($corzblog['is_authorized']) { $do_link = false; }
		}

		if ($do_link) {
			echo '
			<li><a href="',$my_properties['url'],'" title="',$url_title,'" ';
			if (!empty($my_properties['props'])) {
				echo html_entity_decode($my_properties['props'], NULL, 'UTF-8'),' ';
			}
			echo '>',$my_properties['text'],'</a></li>';
		}
	}
	echo '
		</ul>
	</div>';


	// hot (sidebar) links..
	if (!empty($prefs['side_links'])) {

		echo'
	<div title="recommended links.." class="links">
		<h2>',$prefs['links_menu_name'],'</h2>
		<ul>';

		// de{token}ize the entries..
		$prefs['side_links'] = tokenize_links($prefs['side_links'], 'decode');

		foreach($prefs['side_links'] as $my_url => $my_properties) {
			if (!empty($my_properties['title'])) {
				$url_title = strip_tags($my_properties['title']);
			} else {
				$url_title = strip_tags($my_properties['url']);
			}
			echo '
			<li><a href="',$my_properties['url'],'" title="',$url_title,'" ';
			if (!empty($my_properties['props'])) { echo html_entity_decode($my_properties['props'], NULL, 'UTF-8'),' '; }
			echo '>',$my_properties['text'],'</a></li>';
		}
		echo '
		</ul>
	</div>';
	}

	/*
		"blogs" menu..

		presents links to all the blog entries on this page.
		only show when viewing a blog page (not edit/add pages or permalinked entries)
		*/
	if (!empty($prefs['blog_entries']) and (basename($prefs['self']) == 'index.php') and !$perma_view) {

		echo '
	<div title="recent blogs.." class="bloglinks">
		<h2>',$prefs['blogs_menu_name'],'</h2>
		<ul>';

		// for strict xhtml compliance - no empty ul's..
		echo '<li style="display: none;">corzblog!</li>';

		for ($i = 0, $ara = count($prefs['blog_entries']); $i < $ara; $i++) {
			$blog_parts = get_blog_parts($prefs['blog_entries'][$i]);
			$show_title = substr($blog_parts[1], 0, $prefs['truncate']); // for loooong titles
			if ($show_title != $blog_parts[1]) { $show_title = ($show_title.'&hellip;'); }
			echo '
			<li class="bloglink">
				<a href="#',do_valid_id($blog_parts[1]),'" title="'
				,trim($blog_parts[1]),trim(strip_tags($blog_parts[4])),'">',trim(strip_tags($show_title)),'</a>
			</li>';
		}
		echo '
		</ul>
	</div>';

	} else { // no blogs menu required..

		echo '
	<div title="recent blogs.." class="bloglinks">
		<h2>',$prefs['blogs_menu_name'],'</h2>
			<ul>
				<li style="display: none;">corzblog!</li>';
		if ($perma_view) {
			echo '
				<li class="bloglink">
					<a href="#" title="Permalinked View">permalinked view</a>
				</li>';
		}

		echo '
		</ul>
	</div>';
	}
	// end of "blogs" menu



	/*
		newsfeeds..

		the validator started complaining about the rawurlencoding,
		but I did it anyway, they'll catch up.

		ps.. they caught up!
																*/

	if ($prefs['show_feeds']) {
		echo '
	<div title="RSS/RDF (news) feeds.." class="feedtext">
		<h2>',$prefs['feeds_menu_name'],'</h2>
		<ul>
			<li>';
			if ($corzblog['show_valid_links']) {
				echo '
				<div class="valid-link">
					<a href="http://feedvalidator.org/check.cgi?url=',rawurlencode($prefs['blog_url']),'rss.php" title="validate this feed (validators are interchangeable)" onclick="window.open(this.href); return false;">
					rss 0.91 feed..
					</a>
				</div>';

			} else {
				echo '
				<div class="valid-link">
					rss 0.91 feed..
				</div>';
			}
			echo '
				<div class="clear"></div>
				<div class="feedlink">
					<a href="',$prefs['blogzpath'],'rss.php" title="simple rss 0.91 newsfeed for ',$prefs['mysite_clean'],' - THE EMAIL ADDRESS IS FINE!">
					<img src="',$GLOBALS['blog_scheme']['rss_img'],'" alt="probably a valid xml rss 0.91 feed" />
					</a>
				</div>
			</li>
			<li>';
			if ($corzblog['show_valid_links']) {
				echo '
				<div class="valid-link">
					<a href="http://validator.w3.org/feed/check.cgi?url=',rawurlencode($prefs['blog_url']),'rdf.php&amp;Go=Go&amp;box=yes" title="validate this feed (validators are interchangeable)" onclick="window.open(this.href); return false;">
						rss 1.0 feed..
					</a>
				</div>';
			} else {
				echo '
				<div class="valid-link">
						rss 1.0 feed..
				</div>';
			}
			echo '
				<div class="clear"></div>
				<div class="feedlink">
					<a href="',$prefs['blogzpath'],'rdf.php" title="rdf/rss 1.0 newsfeed for ',$prefs['mysite_clean'],'">
						<img src="',$GLOBALS['blog_scheme']['rdf_img'],'" alt="probably a valid xml rdf rss 1.0 feed" />
					</a>
				</div>
			</li>
		</ul>
	</div>';
	}



	/*
		archives..

		and their highly cool 3D drop-down menu.
		there's a whole lot going on in the next two lines..
		*/

	if ( basename($corzblog['self']) != 'add.php' and basename($corzblog['self']) != 'edit.php' ) {

		if ($itemz = parse_arc_dir($prefs['archive_dir'], $prefs['blog_ext'])) {
			$sorted = sort_archives($itemz);
		}

		// don't bother if there's no archives..
		if (!empty($sorted)) {
			echo '
	<!-- corz 3D css menu -->
	<div title="the archives.." class="arcmenu">
		<h2>',$prefs['arcs_menu_name'],'</h2>
		<ul>
			<li>
				<ul>';
			foreach($sorted as $key => $value ) { // loop through the sections (usually years)..
				echo '
					<li title="blogs written during ',$key,'..">',$key,'
						<ul>';
				foreach($sorted[$key] as $blogzname ) { // loop through the available archives..
					if ($prefs['rewrite_links']) {
						echo '
							<li><a href="',$prefs['blog_url'],$key,'-',rawurlencode($blogzname),'"';
					} else {
						echo '
							<li><a href="',$prefs['blog_url'],'index.php?archive=',$key,'-',rawurlencode($blogzname),'"';
					}
					echo ' title="',trim($blogzname),'">',str_replace('_',' ', $blogzname),'</a></li>';
				}
				echo '
						</ul>
					</li>';
			}
			echo '
				</ul>
			</li>
		</ul>
	</div>';
		}// end archives menu.

	}

	echo '
	</nav>
</div>';

	return ob_get_clean	();
}





/*
	a simple error catcher..
	*/

class cbErrHandler {
	function cbgetErrors() {
		if (!empty($GLOBALS['errors']['corzblog'])) {
			return $GLOBALS['errors']['corzblog'];
		}
	}

	function cbstartErrorHandler() {
		set_error_handler(array($this, 'cbhandle_error'));
	}

	function cbhandle_error($type, $string, $file, $line, $vars) {
		if (empty($GLOBALS['errors']['corzblog'])) { $GLOBALS['errors']['corzblog'] = ''; }

		$GLOBALS['errors']['corzblog'] .= ' error on line '.$line.' of '.$file.': '.$string;

		switch (true) {
			case $GLOBALS['corzblog']['error_type'] == 'page':
				echo '
<script>
//<![CDATA[
<!--
if (!debug.box) {
	debug.box = document.createElement("div");
	debug.box.setAttribute("style", "background-color: white; " +
									"font-family: monospace; " +
									"border: solid black 3px; " +
									"padding: 10px;");
	document.body.appendChild(debug.box);
	debug.box.innerHTML = "<h1 style="text-align:center">Debugging Output</h2>";
}
var p = document.createElement("p");
p.appendChild(document.createTextNode('.$GLOBALS['errors']['corzblog'].'));
debug.box.appendChild(p);
//-->
//]]>
</script>
<noscript><!-- JavaScript Debug Box --></noscript>';
				break;

			case $GLOBALS['corzblog']['error_type'] == 'alert':
				echo '
<script>
//<![CDATA[
<!--
	alert("'.$GLOBALS['errors']['corzblog'].'");
//-->
//]]>
</script>
<noscript><!-- JavaScript Alert --></noscript>';
				break;

			default :
		}
	}
}

?>