<?php	/* --- ۞---> text { encoding:utf-8;bom:no;linebreaks:unix;tabs:4sp; } */
/*

	auto-sections.php												   [v 0.2.5]

	An automatic sections menu for your pages..

	This script is called from your page or site-wide header/ footer.

		(let's say the page is named "something.php")

	It interrogates the corresponding included html file..

		(normally "something.htm", though you can pick another extension, even
		'php', instructing auto-sections to interrogate the /current/ document)

	It then plucks out its sections.

		(you used id="section-Some_Thing" in your HTML markup, see)

	And transforms them into a list of links.

		(you get an unordered list with "Some Thing" as one of its items!)


	This output list of links will take users directly to *such-and-such*
	section of your page. You can place this list of link anywhere on your page,
	with CSS. See it in action (top-right of page), here..

		http://corz.org/windows/software/checksum/
		http://corz.org/serv/tricks/htaccess.php

	It is especially useful for LONG pages!


	To Use:

		Simply include on your page (it's more flexible and way easier to put
		this code inside a site-wide header or footer)..

			include $_SERVER['DOCUMENT_ROOT'].'/path/to/auto-sections.php';

		And wherever you want section menus, simply create id tags beginning
		with "section-", and it will be done.

		This script will ONLY output something when your page has one or more
		id="section-SOMETHING"s on it, like so..

			<div id="section-Introduction"><h3>Introduction</h3> ...

		or
			<section id="section-Introduction"><h3>Introduction</h3> ...

		..would create an auto-section item entitled "Introduction", using the
		part of the string directly after "section-" as the text. The whole
		thing looks something like this..

<aside id="corz-auto-section-menu">
	<h1>Automatic Section Menu</h1>
	<div class="auto-section">
		<div class="auto-section-title">
			<a href="#" onclick="GoTop();return false;" id="pagelink-totop">sections: </a>
		</div>
		<nav class="auto-section-links">
			<h1>Automatic Section Links</h1>
			<a href="#section-Section_One" title="Jump to Section One">Section One</a>
			<a href="#section-Section_Two" title="Jump to Section Two">Section Two</a>
			<a href="#section-Section_Three" title="Jump to Section Three">Section Three</a>
			<a href="#section-Section_Four" title="Jump to Section Four">Section Four</a>
		</nav>
	</div>
</aside>



	NOTE: If you use an underscore "_" in your valid id tag, it will be rendered
	as a space " " in the auto-section menu putput.


	Remember, the position of the menu is controlled by CSS, so you will need to
	cook up something nice. Feel free to use mine as a template for your own
	stylings. Load one of above links, grab the CSS if you like - my
	auto-sections are at the top-right of the page, just under the main menus.

	It's definitely the kind of thing you have set to hidden in your print.css

	NOTE: will want to hide the big <nav> section H1 with your CSS, as usual:

	nav h1, aside h1 {
		position: absolute !important;
		clip: rect(1px, 1px, 1px, 1px);
	}

	Place it at the top of the page, and it should make for better SEO, so
	long as you name your sections well; think, 'inverted pyramid'. Mind you,
	it's pretty well tagged up as a <nav>!

	At any rate, I just bung it in my footer.

	Check out the example in the zip. If you copied the source from the corz.org
	source viewer page, go back and get the zip! The viewer output isn't always
	runnable! Also, the zip has a fully-resposive auto-transforming-thingamenu
	demo which you can rip right out!

	Note, if you parse html as php, and have everything in one file, you can
	still use this, simply put 'html' (or whatever) as your extension..

	;o) Cor

	(c) 2006->tomorrow! ~ cor + corz.org ;o)

	Please view the license for this free software, here:

		http://corz.org/free-scripts-licence.nfo

*/



//*>	prefs..

/*
	File to interrogate for extensions..

	Normally this is "htm" (where "some-file.php" gets its content from
	"some-file.htm"), though it can be anything you want.

	** NOTE: If you have your code and content all in one page (ouch!) you can
	still use this, simply set the extension preference to 'php' (or whatever you
	use for php files!), and auto-sections will interrogate the /current/ file
	for sections.
*/
$my_extension = 'htm';

//	end prefs!


// get name if this file..
$auto_menus['name_no_ext'] =  substr($_SERVER['SCRIPT_NAME'], 0, strrpos($_SERVER['SCRIPT_NAME'], '.'));

// load accompanying (usually) content..
if (file_exists($_SERVER['DOCUMENT_ROOT'].$auto_menus['name_no_ext'].'.'.$my_extension)) {
	$auto_menus['page_content'] = file_get_contents($_SERVER['DOCUMENT_ROOT'].$auto_menus['name_no_ext'].'.'.$my_extension );
	$auto_menus['sections_array'] = explode('id="section-', $auto_menus['page_content']);
} else {
	return;
}


// no sections in this page..
if (!isset($auto_menus['sections_array'][1])) { return; }


$menu_string = '
<aside id="corz-auto-section-menu">
	<h1>Automatic Section Menu</h1>
	<div class="auto-section">
		<div class="auto-section-title">
			<a href="#" onclick="GoTop();return false;" title="Click here to go up to the top (only really useful when toolbar is in a fixed position)" id="pagelink-totop">sections: </a>
		</div>
		<nav class="auto-section-links">
			<h1>Automatic Section Links</h1>';

$limit = count($auto_menus['sections_array']);
for ($i = 1; $i < $limit; $i++) {
	$auto_menus['entry'] = substr($auto_menus['sections_array'][$i], 0, strpos($auto_menus['sections_array'][$i], '"'));
		$auto_menus['pretty'] = str_replace("_", " ", substr($auto_menus['entry'], 0)); //was 8
		$menu_string .= '
			<a href="#section-'.$auto_menus['entry'].'" title="Jump to '.$auto_menus['pretty'].'">'.$auto_menus['pretty'].'</a>';
}
echo '
	',$menu_string,'
		</nav>
	</div>
</aside>'."\n";

$auto_menus[] = 0;



/*

2do..

	Different styles/types of sections menu, for popping out *wherever* and *however* on a page.
	Or just make them real bare <ul> and style wherever with classes.





changes:

	0.2.3

		Slightly re-written to enable placement in global header.

		menu-auto-sections now cleverly (or rather, at last!) checks if there
		any actual section id's on the page before spewing out *anything*.

		In other words, you can include this on ALL pages, and it will only kick
		into action if your page has an id="section-SOMETHING" on it.


		I didn't keep notes of changes prior to this, as it was not released.

*/
?>
