<?php // ۞// text { encoding:utf-8 ; bom:no ; linebreaks:unix ; tabs:4sp ; }
//:distro..		\2		->		\2
/*

	Settings for Clever 404		[v1.2]

	The first couple of settings..

		$clever_404['webmaster']
		$clever_404['email_address'])

	..are also used by the accompanying 401, 403, 500, etc., error pages, if you
	use those.

	If you *don't* use those, you could copy all these settings inside 404.php

	;o) Cor
*/


// your name, as your visitors see it..
$clever_404['webmaster'] = 'the webmaster';


/*
	Email Address

	Uses the email-masher (at the foot of this script).

	The email address to mash goes here..

*/
$clever_404['email_address'] = mail_mash('errors@mydomain.com');

// or you can just comment out the two lines above and use simply..
// $clever_404['email_address'] = 'i-like-spam@crazypeople.net'; // un-comment if you like spam


/*
	Location of your css file,
	as used by an @import command..
												*/
$clever_404['css_location'] = '/err/err.css';


/*
	IGNORE folders, for the scanning..

	One '/inc/' covers all '/inc/' folders onsite.
	You can also be more specific, as in '/inc/tools/'

	note commas *between* entries..
									*/
$clever_404['ignore_folders'] = array(
	'/secret/',
	'/private/',
	'/includes/',
	'/err/',
	'/inc/',
	'/demo/',
	'/cgi-bin/'
	);


// files we are allowed to return results for
// note commas *between* entries..
$clever_404['allowed_extensions'] = array(
	'.htm',
	'.html',
	'.shtml',
	'.txt',
	'.doc',
	'.php',
	'.php3',
	'.phps',
	'.jpg',
	'.jpeg',
	'.png',
	'.gif',
	'.nfo',
	'.au3',
	'.zip',
	'.pdf'
	);


/*
	Search Path..

	default: $clever_404['scan_path'] = array('../');

	By default, this script lives in /err so we start searching
	from the folder *above*, '../' i.e. the root of the site.

	If you keep this anywhere *but* in a subfolder of your root,
	please specify the FULL path to the root of your website
	something like..

		$clever_404['scan_path'] = '/var/www/html/';
	or..
		$clever_404['scan_path'] = '/Volumes/mac/webserv/cor/';

	or whatever..
										*/
$clever_404['scan_path'] = '../';

/*
	Exact Match..

	default: $clever_404['exact_match'] = false;

	if a user was looking for "install.txt" and that doesn't exist in the
	location they specified, we will look for "install.txt" everywhere onsite.
	If that filename is found we will return links for files matching
	"install.txt". this is an exact match.

	if this switch is set to false (the default), we will also return hits for
	install.htm, install.php, install.jpg, etc. I prefer this; shows we're
	working extra hard for our visitors. consider the term "web host".
									*/
$clever_404['exact_match'] = false;


// searching for "install.txt", will also return  installation.txt, installer.jpg, and so on.
$clever_404['partial_match'] = true;


/*
	Fuzzy Match..

	If they typed "g-dip" in the address bar, this would return a document entitled "g_dip"
	(note underscore), as well as other *almost* matches. Quite neat, catches some typos,
	'hit' would match 'hot', for example.
*/
$clever_404['fuzzy_match'] = true;

/*
	Fuzziness

	1 is usually fuzzy enough, but 2 is also useful, depending on your file names.
	3 is probably too much. The default is 1..
									*/
$clever_404['fuzziness_level'] = 1;


// if the term appears in a directory name, shall we return that, too?
$clever_404['match_dirs'] = true;

/*

	Show a corzoogle search form?

	default: $clever_404['corzoogle_always'] = true;

	If our scan didn't match any documents, a corzoogle form will be presented,
	thus enabling the user to perform a full content search of our website.

	If you like (and it is cool) you can have a corzoogle search form appear
	anyway, even if we did get a few matching documents. The scanning code
	for 404 is ripped out of corzoogle, anyway.

	Note:	if 'cz_location' (below) is empty, the corzoogle form won't show,
	so you could leave this set to true, and use 'cz_location' as the switch,
	or visa-versa.
										*/
$clever_404['corzoogle_always'] = true;


// leave this empty if corzoogle isn't installed on your site.
$clever_404['cz_location'] = '';	//$clever_404['cz_location'] = '/corzoogle.php';

// location of corzoogle image
$clever_404['cz_img_location'] = '/err/corzoogle_sm.png';



/*
	"catchers"  -  moved pages we catch and redirect-at-once

	If the first item is contained *anywhere* within the URL, the redirection
	will occur. The user won't realize they got a 404. Set these inside
	"moved.ini"..

		some string = "full/path/to/resource"

	basically..

		old/page="/new/page.php"

	You don't have to worry about some site script that uses one of your first
	redirect terms, say "index.php?q=" in its URL's, being redirected by 404,
	remember; if the user hits a valid url, they won't even *get* a 404!
							(.. adapted from a recent communication ;o)

	Because it's a "catch-all", you can put generic terms in and catch any old
	thing, send it to some relevant page.

	NOTE: BE VERY VERY CAREFUL when you edit these values, and TEST on your own
	server before uploading an updated 404. reason? Once you set a permanently
	moved redirection, it can be a bugger to shift, at least on your own system
	(see the 'redirect_testing' setting, below).

	NOTE: if you move "moved.ini" to some other place/file name, change this..

														*/
$clever_404['catchers'] = parse_ini_file('moved.ini');

/*
	!!! IMPORTANT !!!		TEST TEST TEST!		!!! IMPORTANT !!!

	If you are testing new redirects ($clever_404['catchers']), set this to
	true. 404 will use a temporary redirect (302).

	When you are sure everything works as expected, set this to false to start
	sending 301 Permanent redirection headers.
											*/
$clever_404['redirect_testing'] = true;



/*
	catcher redirection domain.

	default: $clever_404['domain'] = $_SERVER['HTTP_HOST'];

	Defaults to THIS domain, but you could redirect your catchers to another
	site, too, if you like..

	$clever_404['domain'] = 'otherplace.com';

*/
$clever_404['domain'] = $_SERVER['HTTP_HOST'];



/*
	Jump on Single Hit

	default: $clever_404['jump_on_single_hit'] = false;

	Should 404 auto-redirect if there's only one single match?

	If the file system scan returns just one document, 404 can jump directly to
	it, in an "I feel lucky" style.

	Visitors go- "WTF! .. CoOL!" probably.

	You'll likely want to enable $clever_404['exact_match'] if you use this,
	though I often don't!

	This feature can use real HTTP headers or meta-refresh, your call
	(see 'jump_method' below).
											*/
$clever_404['jump_on_single_hit'] = false;	// true/false


/*
	Time to Jump

	How many seconds until hyperspace jump?

	Note: you can set this with *extreme* accuracy, e.g.. 2.131572

	If you select $clever_404['jump_method'] = 'meta'; (below) the number will be
	rounded to the nearest whole integer.
										*/
$clever_404['time_to_jump'] = 2;	// a value of 2 ensures we play nice with Anti-Hammer!


/*
	Jump Method

	This only comes into effect if you have set $clever_404['jump_on_single_hit'] (above)
	to true, and the site search returns a single document.

	How to jump the browser to the new page? choices are '301', or 'meta'

	'301' won't even show the page; just like the catchers, above, it will send
	the browser a proper 301 header, redirect immediately to the new page. It's
	probable that, unless they watch the address bar, they won't even realize
	they got a 404.

	'307' acts the same way as 301 (above) but sends a "Temporary Redirect"

	'meta' will show the page for however long you set in $clever_404['time_to_jump'], and THEN
	jump the user to the new page, using a meta "refresh" header.

	BEWARE: a 301 is a fairly permanent redirect (at least for the life of the
	browser session) so use this with caution, especially if you have enabled
	fuzzy matching. However, I do exactly this at corz.org, and it's a lot of
	fun. Let's face it, they got a 404 anyway, so jumping to a new page, *any*
	page, is better than nothing. The fuzzy matching is pretty good, and more
	often than not, it jumps correctly to renamed and mis-typed documents.

	Remember, it only auto-jumps if the site search returned a SINGLE hit, so
	it's very likely that they will end up exactly where they wanted to be.

	Bottom line: Be Gung-Ho! The advantages weigh more!

	NOTE:	This setting does NOT affect your catchers redirections, which are
			/always/ sent with a 301 header (302 in testing mode).

										*/
//$clever_404['jump_method'] = 'meta'; // 301 is better
$clever_404['jump_method'] = '302'; // temporary! until you set your prefs!




/*
	visual stuff..	*/


/*
	Show Full Links?

	default: $clever_404['links_are_full'] = true;

	A display thing. If a match is found, its link and pop-up title can be shown
	as..

		somefile.php

	or as..

		http://mysite.com/whatever/path/to/somefile.php

	which is the "full" version. Either way, they still get the same link,
	and that full link, as always, will be displayed in their status bar.
	just for looks.
									*/
$clever_404['links_are_full'] = true;



// Messages..

$clever_404['message_404']				= 'Maybe you typed the address wrong. What do you think?';
$clever_404['message_found_matches']	= 'The following documents appear to be similar to your request..';
$clever_404['message_found_NO_matches'] = 'I looked, but could not find any matching documents, sorree.';
$clever_404['message_do_a_search']		= 'You might want to corzoogle for it..';

$clever_404['message_400']				= 'Bad Request!';
$clever_404['message_401']				= 'luser!';
$clever_404['message_403']				= 'Stop nosing about!';
$clever_404['message_410']				= 'It is Gone!';
$clever_404['message_500']				= 'Oh Shite!';
$clever_404['message_503']				= 'Oh Oh!';



// 404 doesn't allow users to bring the server down with multiple simultaneous file searches..
// there are bots, too, that delight in hitting non-existent 404's every single second.
// the system temp folder is usually best for the lock file - always world-writable, and
// generally on the system's fastest drive, perhaps even a ram drive or SSD..
//$clever_404['lock_file'] = '/var/www/vhosts/corz.org/httpdocs/inc/sessions/404_lock';
$clever_404['lock_file'] = '/tmp/404_lock';

// this will usually only kick in for crazy bots and web site abusers.
// on my live server and mirror, the site scan is completed in miliseconds, so most folk will never see this.
$clever_404['still_scanning'] = "<small>404 is currently busy scanning the site for another lost document, try again in a moment</small>";





/*
end prefs	*/





/*
	Experimental Stuff..
							*/


// Embed error pages inside another page..
$clever_404['embedded'] = false;


// Logging errors to a file..
$clever_404['error_reporting'] = false;

// log to where..
$clever_404['error_file'] = $_SERVER['DOCUMENT_ROOT'].'/inc/log/.ht_errors';





/*
	common functions..	*/


// common head/foot parts..

function begin_header() {
	echo'<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">';
}

function finish_header() {
	global $clever_404, $corz;

	echo '
<style type="text/css" media="screen">
/*<![CDATA[*/';
echo '
@import "',$clever_404['css_location'],'";
/*]]>*/
</style>
</head>
<body>
<div class="quarter-space">&nbsp;</div>';
}

function end_error_page() {

	global $clever_404;

	// optional error reporting..
	if ($clever_404['error_reporting']) {
		log_errors();
	}

	// do your footer thang here.
	//include 'footer.php';

	// gotta leave my link in, that's the deal!
	echo '
<div class="toplink">
	<a href="http://corz.org/engine?section=php" onclick="window.open(this.href); return false;"
	title="the non-existent file file.. 404, from corz.org">get the source</a>
</div>';

	if (!$clever_404['embedded']) {
		echo '
</body>
</html>';
	}
}


function log_errors() {

	global $clever_404;

	// it's not there, try to create it..
	if (!file_exists($clever_404['error_file'])) {
		$fp = fopen($clever_404['error_file'], 'wb');
	}

	if (file_exists($clever_404['error_file'])) {
		$errors_oops = chr(10).date('Y.m.d h:i:s A')
		.chr(9).$_SERVER['REMOTE_ADDR']
		.chr(9).basename($_SERVER['SCRIPT_NAME'])
		.chr(9).@$_SERVER['HTTP_REFERER']
		.chr(9).$_SERVER['REQUEST_URI']
		.chr(9).@$_SERVER['HTTP_USER_AGENT'];

		// add this entry..
		$fp = fopen($clever_404['error_file'], 'ab');
		fwrite($fp, $errors_oops);
		fclose($fp);
	}
}



/*
	mail_mash()

	a cuter way to foil the spam-bots

	mail_mash will transform email@address.com into a randomly mixed string of real
	"o" and encoded "&#111;" characters. it's different each time the page loads,
	but always presents a valid mailto:email@address.com for a human clicker

	note: the "mailto:" part is also prepended, mixed in to the randomness, so you
	don't need to provide that in your html, just <a href="',mail_mash($email_address),'">
	from inside a php echo, or put a whole php echo statement inside the href if you
	are inside plain html

		your@address.com

	would output *something like*..

		&#109;a&#105;&#108;to:&#121;our&#64;a&#100;&#100;r&#101;ss.&#99;&#111;&#109;

	have fun!

*/
function mail_mash($addy) {

	$addy = 'mailto:'.$addy;
	for($i=0;$i<strlen($addy);$i++) { $letters[] = $addy[$i]; }

	while (list($key, $val) = each($letters)) {
		$r = rand(0,20);
		if ($r > 9) { $letters[$key] = '&#'.ord($letters[$key]).';';}
	}

$mashed_email_addy = implode('', $letters);
return $mashed_email_addy;

}/*
end function mail_mash()	*/

?>